/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.pdf.IPdfPageExtraCopier;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfPageFormCopier
implements IPdfPageExtraCopier {
    PdfAcroForm formFrom;
    PdfAcroForm formTo;
    PdfDocument documentFrom;
    PdfDocument documentTo;
    Logger logger = LoggerFactory.getLogger(PdfPageFormCopier.class);

    public void copy(PdfPage fromPage, PdfPage toPage) {
        if (this.documentFrom != fromPage.getDocument()) {
            this.documentFrom = fromPage.getDocument();
            this.formFrom = PdfAcroForm.getAcroForm(this.documentFrom, false);
        }
        if (this.documentTo != toPage.getDocument()) {
            this.documentTo = toPage.getDocument();
            this.formTo = PdfAcroForm.getAcroForm(this.documentTo, true);
        }
        if (this.formFrom == null) {
            return;
        }
        ArrayList<PdfName> excludedKeys = new ArrayList<PdfName>();
        excludedKeys.add(PdfName.Fields);
        excludedKeys.add(PdfName.DR);
        PdfDictionary dict = ((PdfDictionary)this.formFrom.getPdfObject()).copyTo(this.documentTo, excludedKeys, false);
        ((PdfDictionary)this.formTo.getPdfObject()).mergeDifferent(dict);
        Map<String, PdfFormField> fieldsFrom = this.formFrom.getFormFields();
        if (fieldsFrom.size() <= 0) {
            return;
        }
        Map<String, PdfFormField> fieldsTo = this.formTo.getFormFields();
        List annots = toPage.getAnnotations();
        for (PdfAnnotation annot : annots) {
            if (!annot.getSubtype().equals((Object)PdfName.Widget)) continue;
            this.copyField(toPage, fieldsFrom, fieldsTo, annot);
        }
    }

    private void copyField(PdfPage toPage, Map<String, PdfFormField> fieldsFrom, Map<String, PdfFormField> fieldsTo, PdfAnnotation currentAnnot) {
        PdfDictionary parent = ((PdfDictionary)currentAnnot.getPdfObject()).getAsDictionary(PdfName.Parent);
        if (parent != null) {
            PdfFormField parentField = this.getParentField(parent, this.documentTo);
            PdfString parentName = parentField.getFieldName();
            if (parentName == null) {
                return;
            }
            this.copyParentFormField(toPage, fieldsTo, currentAnnot, parentField);
        } else {
            PdfString annotName = ((PdfDictionary)currentAnnot.getPdfObject()).getAsString(PdfName.T);
            String annotNameString = null;
            if (annotName != null) {
                annotNameString = annotName.toUnicodeString();
            }
            if (annotNameString != null && fieldsFrom.containsKey(annotNameString)) {
                PdfFormField field = fieldsTo.get(annotNameString);
                if (field == null) {
                    this.formTo.addField(PdfFormField.makeFormField(currentAnnot.getPdfObject(), this.documentTo), null);
                } else {
                    this.copyExistingField(toPage, currentAnnot);
                }
            }
        }
    }

    private void copyExistingField(PdfPage toPage, PdfAnnotation currentAnnot) {
        PdfFormField field = this.mergeFieldsWithTheSameName(PdfFormField.makeFormField(currentAnnot.getPdfObject(), toPage.getDocument()));
        PdfArray kids = field.getKids();
        if (kids != null) {
            ((PdfDictionary)field.getPdfObject()).remove(PdfName.Kids);
            this.formTo.addField(field, toPage);
            ((PdfDictionary)field.getPdfObject()).put(PdfName.Kids, (PdfObject)kids);
        } else {
            this.formTo.addField(field, toPage);
        }
    }

    private void copyParentFormField(PdfPage toPage, Map<String, PdfFormField> fieldsTo, PdfAnnotation annot, PdfFormField parentField) {
        PdfString parentName = parentField.getFieldName();
        if (!fieldsTo.containsKey(parentName.toUnicodeString())) {
            PdfFormField field = this.createParentFieldCopy((PdfDictionary)annot.getPdfObject(), this.documentTo);
            PdfArray kids = field.getKids();
            ((PdfDictionary)field.getPdfObject()).remove(PdfName.Kids);
            this.formTo.addField(field, toPage);
            ((PdfDictionary)field.getPdfObject()).put(PdfName.Kids, (PdfObject)kids);
        } else {
            PdfFormField field = PdfFormField.makeFormField(annot.getPdfObject(), this.documentTo);
            PdfString fieldName = field.getFieldName();
            if (fieldName != null) {
                PdfFormField existingField = fieldsTo.get(fieldName.toUnicodeString());
                if (existingField != null) {
                    PdfFormField mergedField = this.mergeFieldsWithTheSameName(field);
                    this.formTo.getFormFields().put(mergedField.getFieldName().toUnicodeString(), mergedField);
                } else {
                    HashSet<String> existingFields = new HashSet<String>();
                    this.getAllFieldNames(this.formTo.getFields(), existingFields);
                    this.addChildToExistingParent((PdfDictionary)annot.getPdfObject(), existingFields, fieldsTo, toPage, annot);
                }
            } else if (!parentField.getKids().contains(field.getPdfObject())) {
                HashSet<String> existingFields = new HashSet<String>();
                this.getAllFieldNames(this.formTo.getFields(), existingFields);
                this.addChildToExistingParent((PdfDictionary)annot.getPdfObject(), existingFields);
            }
        }
    }

    private PdfFormField mergeFieldsWithTheSameName(PdfFormField newField) {
        String fullFieldName = newField.getFieldName().toUnicodeString();
        PdfString fieldName = ((PdfDictionary)newField.getPdfObject()).getAsString(PdfName.T);
        this.logger.warn(MessageFormatUtil.format((String)"The document already has field {0}. Annotations of the fields with this name will be added to the existing one as children. If you want to have separate fields, please, rename them manually before copying.", (Object[])new Object[]{fullFieldName}));
        PdfFormField existingField = this.formTo.getField(fullFieldName);
        if (existingField.isFlushed()) {
            int index = 0;
            do {
                newField.setFieldName(fieldName.toUnicodeString() + "_#" + ++index);
            } while (this.formTo.getField(fullFieldName = newField.getFieldName().toUnicodeString()) != null);
            return newField;
        }
        ((PdfDictionary)newField.getPdfObject()).remove(PdfName.T);
        ((PdfDictionary)newField.getPdfObject()).remove(PdfName.P);
        this.formTo.getFields().remove(existingField.getPdfObject());
        PdfArray kids = existingField.getKids();
        if (kids != null && !kids.isEmpty()) {
            existingField.addKid(newField);
            return existingField;
        }
        ((PdfDictionary)existingField.getPdfObject()).remove(PdfName.T);
        ((PdfDictionary)existingField.getPdfObject()).remove(PdfName.P);
        PdfFormField mergedField = PdfFormField.createEmptyField(this.documentTo);
        mergedField.put(PdfName.FT, (PdfObject)existingField.getFormType()).put(PdfName.T, (PdfObject)fieldName);
        PdfDictionary parent = existingField.getParent();
        if (parent != null) {
            mergedField.put(PdfName.Parent, (PdfObject)parent);
            PdfArray parentKids = parent.getAsArray(PdfName.Kids);
            for (int i = 0; i < parentKids.size(); ++i) {
                PdfObject obj = parentKids.get(i);
                if (obj != existingField.getPdfObject()) continue;
                parentKids.set(i, mergedField.getPdfObject());
                break;
            }
        }
        if ((kids = existingField.getKids()) != null) {
            mergedField.put(PdfName.Kids, (PdfObject)kids);
        }
        mergedField.addKid(existingField).addKid(newField);
        PdfObject value = existingField.getValue();
        if (value != null) {
            mergedField.put(PdfName.V, ((PdfDictionary)existingField.getPdfObject()).get(PdfName.V));
        }
        return mergedField;
    }

    private PdfFormField getParentField(PdfDictionary parent, PdfDocument pdfDoc) {
        PdfFormField parentField = PdfFormField.makeFormField((PdfObject)parent, pdfDoc);
        PdfDictionary parentOfParent = parentField.getParent();
        if (parentOfParent != null) {
            parentField = this.getParentField(parentOfParent, pdfDoc);
        }
        return parentField;
    }

    private PdfFormField createParentFieldCopy(PdfDictionary fieldDic, PdfDocument pdfDoc) {
        PdfDictionary parent = fieldDic.getAsDictionary(PdfName.Parent);
        PdfFormField field = PdfFormField.makeFormField((PdfObject)fieldDic, pdfDoc);
        if (parent != null) {
            field = this.createParentFieldCopy(parent, pdfDoc);
            PdfArray kids = (PdfArray)parent.get(PdfName.Kids);
            if (kids == null) {
                parent.put(PdfName.Kids, (PdfObject)new PdfArray((PdfObject)fieldDic));
            } else {
                kids.add((PdfObject)fieldDic);
            }
        }
        return field;
    }

    private void addChildToExistingParent(PdfDictionary fieldDic, Set<String> existingFields) {
        PdfDictionary parent = fieldDic.getAsDictionary(PdfName.Parent);
        if (parent == null) {
            return;
        }
        PdfString parentName = parent.getAsString(PdfName.T);
        if (parentName != null) {
            String name = parentName.toUnicodeString();
            if (existingFields.contains(name)) {
                PdfArray kids = parent.getAsArray(PdfName.Kids);
                kids.add((PdfObject)fieldDic);
            } else {
                parent.put(PdfName.Kids, (PdfObject)new PdfArray((PdfObject)fieldDic));
                this.addChildToExistingParent(parent, existingFields);
            }
        }
    }

    private void addChildToExistingParent(PdfDictionary fieldDic, Set<String> existingFields, Map<String, PdfFormField> fieldsTo, PdfPage toPage, PdfAnnotation annot) {
        PdfDictionary parent = fieldDic.getAsDictionary(PdfName.Parent);
        if (parent == null) {
            return;
        }
        PdfString parentName = parent.getAsString(PdfName.T);
        if (parentName != null) {
            String name = parentName.toUnicodeString();
            if (existingFields.contains(name)) {
                PdfArray kids = parent.getAsArray(PdfName.Kids);
                for (PdfObject kid : kids) {
                    if (!((PdfDictionary)kid).get(PdfName.T).equals(fieldDic.get(PdfName.T))) continue;
                    PdfFormField kidField = PdfFormField.makeFormField(kid, this.documentTo);
                    fieldsTo.put(kidField.getFieldName().toUnicodeString(), kidField);
                    PdfFormField mergedField = this.mergeFieldsWithTheSameName(PdfFormField.makeFormField((PdfObject)fieldDic, this.documentTo));
                    this.formTo.getFormFields().put(mergedField.getFieldName().toUnicodeString(), mergedField);
                    return;
                }
                kids.add((PdfObject)fieldDic);
            } else {
                parent.put(PdfName.Kids, (PdfObject)new PdfArray((PdfObject)fieldDic));
                this.addChildToExistingParent(parent, existingFields);
            }
        }
    }

    private void getAllFieldNames(PdfArray fields, Set<String> existingFields) {
        for (PdfObject field : fields) {
            PdfArray kids;
            if (field.isFlushed()) continue;
            PdfDictionary dic = (PdfDictionary)field;
            PdfString name = dic.getAsString(PdfName.T);
            if (name != null) {
                existingFields.add(name.toUnicodeString());
            }
            if ((kids = dic.getAsArray(PdfName.Kids)) == null) continue;
            this.getAllFieldNames(kids, existingFields);
        }
    }
}

