/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.izone.web.shiro;

import com.iteaj.izone.api.LoggerType;
import com.iteaj.izone.spi.event.EventPublisher;
import com.iteaj.izone.web.shiro.ShiroAuthorEvent;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.spring.security.interceptor.AopAllianceAnnotationsAuthorizingMethodInterceptor;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.subject.WebSubject;

public class AuthorizingLogMethodInterceptor
extends AopAllianceAnnotationsAuthorizingMethodInterceptor {
    private EventPublisher eventPublisher;

    public AuthorizingLogMethodInterceptor(EventPublisher asyncPublisher) {
        this.eventPublisher = asyncPublisher;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        LoggerType status = LoggerType.Success;
        WebSubject subject = (WebSubject)SecurityUtils.getSubject();
        Object source = subject.getPrincipal();
        long startTime = System.currentTimeMillis();
        try {
            Object object = super.invoke(methodInvocation);
            return object;
        }
        catch (UnauthorizedException ae) {
            status = LoggerType.UnAuthor;
            throw ae;
        }
        catch (UnauthenticatedException ue) {
            status = LoggerType.UnAuth;
            throw ue;
        }
        catch (Throwable throwable) {
            status = LoggerType.Error;
            status.desc = throwable.getMessage();
            throw throwable;
        }
        finally {
            if (this.eventPublisher != null) {
                ShiroHttpServletRequest servletRequest = (ShiroHttpServletRequest)subject.getServletRequest();
                long operaTime = System.currentTimeMillis() - startTime;
                Method method = methodInvocation.getMethod();
                Object[] arguments = methodInvocation.getArguments();
                this.eventPublisher.publish(new ShiroAuthorEvent(source, (HttpServletRequest)servletRequest, status).setMethod(method).setArgs(arguments).setOperaTimeMillis(operaTime));
            }
        }
    }
}

