/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.izone.web.shiro;

import com.iteaj.izone.web.shiro.NameableFilterConfig;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.springframework.web.context.ServletContextAware;

public class AjaxFilter
extends AccessControlFilter
implements ServletContextAware {
    private boolean isAjax = false;

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        try {
            String ajaxId;
            if (this.isLoginRequest(request, response)) {
                return true;
            }
            if (SecurityUtils.getSubject().isAuthenticated()) {
                return true;
            }
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && (ajaxId = ((HttpServletRequest)request).getHeader("x-requested-with")) != null && ajaxId.equalsIgnoreCase("XMLHttpRequest")) {
                this.isAjax = true;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    public FilterConfig getFilterConfig() {
        return new NameableFilterConfig("ajax", this.getServletContext());
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isAjax) {
            ((HttpServletResponse)response).sendError(401, this.getLoginUrl());
            this.isAjax = false;
            return false;
        }
        return true;
    }
}

