/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.user;

import com.iohao.game.action.skeleton.core.BarMessageKit;
import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.CmdKit;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.external.client.command.CallbackDelegate;
import com.iohao.game.external.client.command.CommandResult;
import com.iohao.game.external.client.command.InputCommand;
import com.iohao.game.external.client.command.ListenCommand;
import com.iohao.game.external.client.command.RequestCommand;
import com.iohao.game.external.client.command.RequestDataDelegate;
import com.iohao.game.external.client.kit.ClientUserConfigs;
import com.iohao.game.external.client.user.ClientChannelRead;
import com.iohao.game.external.client.user.DefaultClientUser;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jctools.maps.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUserChannel {
    private static final Logger log = LoggerFactory.getLogger(ClientUserChannel.class);
    private final AtomicInteger msgIdSeq = new AtomicInteger(1);
    private final AtomicBoolean starting = new AtomicBoolean();
    private final Map<Integer, RequestCommand> callbackMap = new NonBlockingHashMap();
    private final Map<Integer, ListenCommand> listenMap = new NonBlockingHashMap();
    private ClientChannelRead channelRead = new DefaultChannelRead();
    private final DefaultClientUser clientUser;
    public Runnable closeChannel;
    public Consumer<BarMessage> clientChannel;
    public InetSocketAddress inetSocketAddress;

    public ClientUserChannel(DefaultClientUser clientUser) {
        this.clientUser = clientUser;
    }

    public void request(InputCommand inputCommand) {
        CmdInfo cmdInfo = inputCommand.getCmdInfo();
        RequestDataDelegate requestData = inputCommand.getRequestData();
        CallbackDelegate callback = inputCommand.getCallback();
        RequestCommand requestCommand = new RequestCommand().setCmdMerge(cmdInfo.getCmdMerge()).setTitle(inputCommand.getTitle()).setRequestData(requestData).setCallback(callback);
        this.execute(requestCommand);
    }

    public void execute(RequestCommand requestCommand) {
        int msgId = this.msgIdSeq.incrementAndGet();
        this.callbackMap.put(msgId, requestCommand);
        CmdInfo cmdInfo = CmdInfo.of((int)requestCommand.getCmdMerge());
        RequestMessage requestMessage = BarMessageKit.createRequestMessage((CmdInfo)cmdInfo);
        HeadMetadata headMetadata = requestMessage.getHeadMetadata();
        headMetadata.setMsgId(msgId);
        RequestDataDelegate requestData = requestCommand.getRequestData();
        Object data = "";
        if (Objects.nonNull(requestData)) {
            data = requestData.createRequestData();
            byte[] encode = DataCodecKit.encode((Object)data);
            requestMessage.setData(encode);
        }
        if (ClientUserConfigs.openLogRequestCommand) {
            long userId = this.clientUser.getUserId();
            log.info("\u73a9\u5bb6[{}] \u53d1\u8d77\u3010{}\u3011\u8bf7\u6c42 - [msgId:{}] {} {}", new Object[]{userId, requestCommand.getTitle(), msgId, CmdKit.mergeToShort((int)cmdInfo.getCmdMerge()), data});
        }
        this.writeAndFlush((BarMessage)requestMessage);
    }

    public void readMessage(BarMessage message) {
        this.channelRead.read(message);
    }

    public void writeAndFlush(BarMessage message) {
        if (Objects.isNull(this.clientChannel)) {
            return;
        }
        InetSocketAddress inetSocketAddress = this.inetSocketAddress;
        if (Objects.nonNull(inetSocketAddress)) {
            message.getHeadMetadata().setInetSocketAddress((Object)inetSocketAddress);
        }
        this.clientChannel.accept(message);
    }

    public void addListen(ListenCommand listenCommand) {
        int cmdMerge = listenCommand.getCmdInfo().getCmdMerge();
        this.listenMap.put(cmdMerge, listenCommand);
    }

    public void closeChannel() {
        this.clientUser.setActive(false);
        Optional.ofNullable(this.closeChannel).ifPresent(Runnable::run);
    }

    public AtomicInteger getMsgIdSeq() {
        return this.msgIdSeq;
    }

    public AtomicBoolean getStarting() {
        return this.starting;
    }

    public Map<Integer, RequestCommand> getCallbackMap() {
        return this.callbackMap;
    }

    public Map<Integer, ListenCommand> getListenMap() {
        return this.listenMap;
    }

    public ClientChannelRead getChannelRead() {
        return this.channelRead;
    }

    public DefaultClientUser getClientUser() {
        return this.clientUser;
    }

    public Runnable getCloseChannel() {
        return this.closeChannel;
    }

    public Consumer<BarMessage> getClientChannel() {
        return this.clientChannel;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSocketAddress;
    }

    public void setChannelRead(ClientChannelRead channelRead) {
        this.channelRead = channelRead;
    }

    public void setCloseChannel(Runnable closeChannel) {
        this.closeChannel = closeChannel;
    }

    public void setClientChannel(Consumer<BarMessage> clientChannel) {
        this.clientChannel = clientChannel;
    }

    public void setInetSocketAddress(InetSocketAddress inetSocketAddress) {
        this.inetSocketAddress = inetSocketAddress;
    }

    class DefaultChannelRead
    implements ClientChannelRead {
        DefaultChannelRead() {
        }

        @Override
        public void read(BarMessage message) {
            HeadMetadata headMetadata = message.getHeadMetadata();
            int responseStatus = message.getResponseStatus();
            if (responseStatus != 0) {
                log.error("[\u9519\u8bef\u7801:{}] - [\u6d88\u606f:{}] - {}", new Object[]{responseStatus, message.getValidatorMsg(), headMetadata.getCmdInfo()});
                return;
            }
            if (headMetadata.getCmdCode() == 0) {
                this.printLog(message);
                return;
            }
            CommandResult commandResult = new CommandResult(message);
            int msgId = headMetadata.getMsgId();
            RequestCommand requestCommand = ClientUserChannel.this.callbackMap.remove(msgId);
            if (Objects.nonNull(requestCommand)) {
                this.printLog(headMetadata, requestCommand);
                Optional.ofNullable(requestCommand.getCallback()).ifPresent(callback -> callback.callback(commandResult));
                return;
            }
            int cmdMerge = headMetadata.getCmdMerge();
            ListenCommand listenCommand = ClientUserChannel.this.listenMap.get(cmdMerge);
            if (Objects.nonNull(listenCommand)) {
                this.printLog(listenCommand, cmdMerge);
                listenCommand.getCallback().callback(commandResult);
            }
        }

        private void printLog(BarMessage message) {
            if (ClientUserConfigs.openLogIdle) {
                log.info("\u63a5\u6536\u670d\u52a1\u5668\u5fc3\u8df3\u56de\u8c03 : {}", (Object)message);
            }
        }

        private void printLog(ListenCommand listenCommand, int cmdMerge) {
            if (ClientUserConfigs.openLogListenBroadcast) {
                log.info("\u5e7f\u64ad\u76d1\u542c\u56de\u8c03 [{}] \u901a\u77e5 {}", (Object)listenCommand.getTitle(), (Object)CmdKit.mergeToShort((int)cmdMerge));
            }
        }

        private void printLog(HeadMetadata headMetadata, RequestCommand requestCommand) {
            if (ClientUserConfigs.openLogRequestCallback) {
                long userId = ClientUserChannel.this.clientUser.getUserId();
                int cmdMerge = headMetadata.getCmdMerge();
                log.info("\u73a9\u5bb6[{}] \u63a5\u6536\u3010{}\u3011\u56de\u8c03 - [msgId:{}] {}", new Object[]{userId, requestCommand.getTitle(), headMetadata.getMsgId(), CmdKit.mergeToShort((int)cmdMerge)});
                CallbackDelegate callback = requestCommand.getCallback();
                if (Objects.isNull(callback)) {
                    log.warn("callback is null");
                }
            }
        }
    }
}

