/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.join;

import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.external.client.ClientConnectOption;
import com.iohao.game.external.client.join.ClientConnect;
import com.iohao.game.external.client.user.ClientUser;
import com.iohao.game.external.client.user.ClientUserChannel;
import com.iohao.game.external.core.message.ExternalCodecKit;
import com.iohao.game.external.core.message.ExternalMessage;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketClientStartup
implements ClientConnect {
    private static final Logger log = LoggerFactory.getLogger((String)"CommonStdout");

    WebSocketClientStartup() {
    }

    @Override
    public void connect(ClientConnectOption option) {
        ClientUser clientUser = option.getClientUser();
        final ClientUserChannel clientUserChannel = clientUser.getClientUserChannel();
        String wsUrl = option.getWsUrl();
        URI uri = null;
        try {
            uri = new URI(wsUrl);
        }
        catch (URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        WebSocketClient webSocketClient = new WebSocketClient(this, Objects.requireNonNull(uri), (Draft)new Draft_6455()){

            public void onOpen(ServerHandshake handshakedata) {
            }

            public void onMessage(String s) {
                log.info("onMessage : {}", (Object)s);
            }

            public void onClose(int i, String s, boolean b) {
                log.info("onClose : {}", (Object)s);
            }

            public void onError(Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }

            public void onMessage(ByteBuffer byteBuffer) {
                byte[] msgBytes = byteBuffer.array();
                ExternalMessage externalMessage = (ExternalMessage)DataCodecKit.decode((byte[])msgBytes, ExternalMessage.class);
                RequestMessage message = ExternalCodecKit.convertRequestMessage((Object)externalMessage);
                clientUserChannel.readMessage((BarMessage)message);
            }
        };
        clientUserChannel.setClientChannel(message -> {
            ExternalMessage externalMessage = (ExternalMessage)ExternalCodecKit.convertExternalMessage((BarMessage)message);
            byte[] bytes = DataCodecKit.encode((Object)externalMessage);
            webSocketClient.send(bytes);
        });
        clientUserChannel.setCloseChannel(() -> ((WebSocketClient)webSocketClient).close());
        clientUser.getClientUserInputCommands().start();
        webSocketClient.connect();
    }
}

