/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.join;

import com.iohao.game.external.client.ClientConnectOption;
import com.iohao.game.external.client.join.ClientConnect;
import com.iohao.game.external.client.join.ClientTcpExternalCodec;
import com.iohao.game.external.client.join.handler.ClientMessageHandler;
import com.iohao.game.external.client.user.ClientUser;
import com.iohao.game.external.client.user.ClientUserChannel;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpClientStartup
implements ClientConnect {
    private static final Logger log = LoggerFactory.getLogger((String)"CommonStdout");
    static int PACKAGE_MAX_SIZE = 0x100000;

    TcpClientStartup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ClientConnectOption option) {
        ClientUser clientUser = option.getClientUser();
        final ClientMessageHandler clientMessageHandler = new ClientMessageHandler(clientUser);
        NioEventLoopGroup group = new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(PACKAGE_MAX_SIZE, 0, 4, 0, 0)});
                pipeline.addLast("codec", (ChannelHandler)new ClientTcpExternalCodec());
                pipeline.addLast(new ChannelHandler[]{clientMessageHandler});
            }
        });
        InetSocketAddress address = option.getSocketAddress();
        String hostName = address.getHostName();
        int port = address.getPort();
        ChannelFuture channelFuture = bootstrap.connect(hostName, port);
        try {
            Channel channel = channelFuture.sync().channel();
            ClientUserChannel userChannel = clientUser.getClientUserChannel();
            userChannel.setClientChannel(arg_0 -> ((Channel)channel).writeAndFlush(arg_0));
            userChannel.setCloseChannel(() -> ((Channel)channel).close());
            clientUser.getClientUserInputCommands().start();
            channel.closeFuture().await();
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

