/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.command;

import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.common.kit.StrKit;
import com.iohao.game.external.client.command.CallbackDelegate;
import com.iohao.game.external.client.command.RequestDataDelegate;
import com.iohao.game.external.client.kit.ClientKit;

public class InputCommand {
    private final String inputName;
    private final CmdInfo cmdInfo;
    private String title = "... ...";
    private String cmdName = "";
    private RequestDataDelegate requestData;
    private CallbackDelegate callback;

    public InputCommand(CmdInfo cmdInfo) {
        this.inputName = ClientKit.toInputName(cmdInfo);
        this.cmdInfo = cmdInfo;
    }

    public InputCommand setRequestData(RequestDataDelegate requestData) {
        this.requestData = requestData;
        return this;
    }

    public InputCommand callback(CallbackDelegate callback) {
        this.callback = callback;
        return this;
    }

    public String toString() {
        if (StrKit.isEmpty((String)this.cmdName)) {
            String format = "%s    :    %s";
            return String.format(format, this.inputName, this.title);
        }
        String format = "%s    :    [%s] - %s";
        return String.format(format, this.inputName, this.cmdName, this.title);
    }

    public String getInputName() {
        return this.inputName;
    }

    public CmdInfo getCmdInfo() {
        return this.cmdInfo;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCmdName() {
        return this.cmdName;
    }

    public RequestDataDelegate getRequestData() {
        return this.requestData;
    }

    public CallbackDelegate getCallback() {
        return this.callback;
    }

    public InputCommand setTitle(String title) {
        this.title = title;
        return this;
    }

    public InputCommand setCmdName(String cmdName) {
        this.cmdName = cmdName;
        return this;
    }

    private InputCommand setCallback(CallbackDelegate callback) {
        this.callback = callback;
        return this;
    }
}

