/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.command;

import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.core.CmdKit;
import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.action.skeleton.protocol.wrapper.BoolValue;
import com.iohao.game.action.skeleton.protocol.wrapper.BoolValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.ByteValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValue;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValue;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValueList;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValue;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValueList;
import com.iohao.game.common.kit.StrKit;
import com.iohao.game.external.core.message.ExternalMessage;
import java.util.List;
import java.util.Objects;

public class CommandResult {
    final BarMessage message;
    Object value;

    public CommandResult(BarMessage message) {
        this.message = message;
    }

    public ExternalMessage getExternalMessage() {
        return (ExternalMessage)this.message.getHeadMetadata().getExternalMessage();
    }

    public int getMsgId() {
        return this.message.getHeadMetadata().getMsgId();
    }

    public CmdInfo getCmdInfo() {
        return this.message.getHeadMetadata().getCmdInfo();
    }

    public <T> T getValue(Class<? extends T> clazz) {
        byte[] data = this.message.getData();
        if (Objects.isNull(this.value)) {
            this.value = DataCodecKit.decode((byte[])data, clazz);
        }
        return (T)this.value;
    }

    public <T> List<T> listValue(Class<? extends T> clazz) {
        return this.getValue(ByteValueList.class).values.stream().map(v -> DataCodecKit.decode((byte[])v, (Class)clazz)).toList();
    }

    public String getString() {
        return this.getValue(StringValue.class).value;
    }

    public List<String> listString() {
        return this.getValue(StringValueList.class).values;
    }

    public int getInt() {
        return this.getValue(IntValue.class).value;
    }

    public List<Integer> listInt() {
        return this.getValue(IntValueList.class).values;
    }

    public long getLong() {
        return this.getValue(LongValue.class).value;
    }

    public List<Long> listLong() {
        return this.getValue(LongValueList.class).values;
    }

    public boolean getBoolean() {
        return this.getValue(BoolValue.class).value;
    }

    public List<Boolean> listBoolean() {
        return this.getValue(BoolValueList.class).values;
    }

    public String toString() {
        CmdInfo cmdInfo = this.getCmdInfo();
        return StrKit.format((CharSequence)"msgId:{} - {} \n{}", (Object[])new Object[]{this.getMsgId(), CmdKit.mergeToShort((int)cmdInfo.getCmdMerge()), this.value});
    }
}

