/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client;

import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.action.skeleton.protocol.wrapper.IntValue;
import com.iohao.game.action.skeleton.protocol.wrapper.LongValue;
import com.iohao.game.action.skeleton.protocol.wrapper.StringValue;
import com.iohao.game.external.client.command.InputCommand;
import com.iohao.game.external.client.command.RequestDataDelegate;
import com.iohao.game.external.client.kit.AssertKit;
import com.iohao.game.external.client.kit.ClientKit;
import com.iohao.game.external.client.kit.ClientUserConfigs;
import com.iohao.game.external.client.kit.ScannerKit;
import com.iohao.game.external.client.user.ClientUserInputCommands;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputCommandCreate {
    private static final Logger log = LoggerFactory.getLogger(InputCommandCreate.class);
    public int cmd = -1;
    public boolean uniqueInputCommand = ClientUserConfigs.uniqueInputCommand;
    public String cmdName = "";
    public ClientUserInputCommands clientUserInputCommands;

    public CmdInfo ofCmdInfo(int subCmd) {
        AssertKit.assertTrueThrow(this.cmd < 0, "cmd \u4e0d\u80fd\u5c0f\u4e8e 0");
        return CmdInfo.of((int)this.cmd, (int)subCmd);
    }

    public InputCommand getInputCommand(int subCmd) {
        CmdInfo cmdInfo = this.ofCmdInfo(subCmd);
        InputCommand inputCommand = this.clientUserInputCommands.getInputCommand(cmdInfo);
        Objects.requireNonNull(inputCommand, "\u6ca1\u6709\u5bf9\u5e94\u7684\u8bf7\u6c42\u914d\u7f6e");
        return inputCommand;
    }

    public InputCommand ofInputCommand(int subCmd) {
        return this.ofInputCommand(subCmd, null);
    }

    private InputCommand ofInputCommand(int subCmd, RequestDataDelegate requestData) {
        CmdInfo cmdInfo = this.ofCmdInfo(subCmd);
        this.extractedChecked(cmdInfo);
        return this.clientUserInputCommands.ofCommand(cmdInfo).setCmdName(this.cmdName).setRequestData(requestData);
    }

    private void extractedChecked(CmdInfo cmdInfo) {
        String inputName;
        InputCommand inputCommand;
        if (this.uniqueInputCommand && Objects.nonNull(inputCommand = this.clientUserInputCommands.getInputCommand(inputName = ClientKit.toInputName(cmdInfo)))) {
            throw new RuntimeException("\u5b58\u5728\u91cd\u590d\u7684\u8def\u7531\u547d\u4ee4 : " + String.valueOf(cmdInfo));
        }
    }

    public InputCommand ofInputCommandLong(int subCmd) {
        RequestDataDelegate requestData = this.nextParamLong("\u53c2\u6570");
        return this.ofInputCommand(subCmd, requestData);
    }

    public InputCommand ofInputCommandUserId(int subCmd) {
        RequestDataDelegate requestData = this.nextParamLong("\u5bf9\u65b9\u7684 userId");
        return this.ofInputCommand(subCmd, requestData);
    }

    public RequestDataDelegate nextParamLong(String paramTips) {
        return () -> {
            String info = "\u8bf7\u8f93\u5165{} | \u53c2\u6570\u7c7b\u578b : {}";
            log.info(info, (Object)paramTips, Long.TYPE);
            long longValue = ScannerKit.nextLong();
            return LongValue.of((long)longValue);
        };
    }

    public InputCommand ofInputCommandInt(int subCmd) {
        RequestDataDelegate requestData = this.nextParamInt("\u53c2\u6570");
        return this.ofInputCommand(subCmd, requestData);
    }

    public RequestDataDelegate nextParamInt(String paramTips) {
        return () -> {
            String info = "\u8bf7\u8f93\u5165{} | \u53c2\u6570\u7c7b\u578b : {}";
            log.info(info, (Object)paramTips, Integer.TYPE);
            int intValue = ScannerKit.nextInt();
            return IntValue.of((int)intValue);
        };
    }

    public InputCommand ofInputCommandString(int subCmd) {
        RequestDataDelegate requestData = this.nextParamString("\u53c2\u6570");
        return this.ofInputCommand(subCmd, requestData);
    }

    public RequestDataDelegate nextParamString(String paramTips) {
        return () -> {
            String info = "\u8bf7\u8f93\u5165{} | \u53c2\u6570\u7c7b\u578b : {}";
            log.info(info, (Object)paramTips, String.class);
            String s = ScannerKit.nextLine();
            Objects.requireNonNull(s);
            return StringValue.of((String)s);
        };
    }

    public void setCmd(int cmd) {
        this.cmd = cmd;
    }

    public void setUniqueInputCommand(boolean uniqueInputCommand) {
        this.uniqueInputCommand = uniqueInputCommand;
    }

    public void setCmdName(String cmdName) {
        this.cmdName = cmdName;
    }

    public void setClientUserInputCommands(ClientUserInputCommands clientUserInputCommands) {
        this.clientUserInputCommands = clientUserInputCommands;
    }

    public int getCmd() {
        return this.cmd;
    }

    public boolean isUniqueInputCommand() {
        return this.uniqueInputCommand;
    }

    public String getCmdName() {
        return this.cmdName;
    }

    public ClientUserInputCommands getClientUserInputCommands() {
        return this.clientUserInputCommands;
    }
}

