/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.user;

import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.common.kit.InternalKit;
import com.iohao.game.common.kit.StrKit;
import com.iohao.game.external.client.command.InputCommand;
import com.iohao.game.external.client.command.RequestCommand;
import com.iohao.game.external.client.kit.ClientKit;
import com.iohao.game.external.client.kit.ClientUserConfigs;
import com.iohao.game.external.client.kit.ScannerKit;
import com.iohao.game.external.client.user.ClientUserChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUserInputCommands {
    private static final Logger log = LoggerFactory.getLogger(ClientUserInputCommands.class);
    final AtomicBoolean starting = new AtomicBoolean();
    final ClientUserChannel clientUserChannel;
    Map<String, InputCommand> inputCommandMap = new LinkedHashMap<String, InputCommand>();

    public ClientUserInputCommands(ClientUserChannel clientUserChannel) {
        this.clientUserChannel = clientUserChannel;
    }

    private void addCommand(InputCommand inputCommand) {
        Objects.requireNonNull(inputCommand);
        String inputName = inputCommand.getInputName();
        this.inputCommandMap.put(inputName, inputCommand);
    }

    public String toInputName(CmdInfo cmdInfo) {
        return ClientKit.toInputName(cmdInfo);
    }

    public InputCommand ofCommand(CmdInfo cmdInfo) {
        InputCommand inputCommand = new InputCommand(cmdInfo);
        this.addCommand(inputCommand);
        return inputCommand;
    }

    public InputCommand getInputCommand(String inputName) {
        return this.inputCommandMap.get(inputName);
    }

    public InputCommand getInputCommand(CmdInfo cmdInfo) {
        String inputName = this.toInputName(cmdInfo);
        return this.inputCommandMap.get(inputName);
    }

    public RequestCommand ofRequestCommand(CmdInfo cmdInfo) {
        InputCommand inputCommand = this.getInputCommand(cmdInfo);
        return new RequestCommand(inputCommand, this);
    }

    public void request(CmdInfo cmdInfo) {
        String inputName = ClientKit.toInputName(cmdInfo);
        this.request(inputName);
    }

    void request(String inputName) {
        InputCommand inputCommand = this.getInputCommand(inputName);
        if (Objects.isNull(inputCommand)) {
            System.err.printf("\u3010%s\u3011\u547d\u4ee4\u4e0d\u5b58\u5728\n", inputName);
            return;
        }
        System.out.println(inputCommand);
        try {
            this.clientUserChannel.request(inputCommand);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    public void help() {
        System.out.println("---------- cmd help ----------");
        this.inputCommandMap.forEach((s, inputCommand) -> System.out.println(inputCommand.toString()));
        System.out.println("------------------------------");
    }

    public void listenHelp() {
        System.out.println("---------- \u5e7f\u64ad\u76d1\u542c help ----------");
        this.clientUserChannel.getListenBroadcastMap().values().forEach(System.out::println);
        System.out.println("------------------------------");
    }

    public void start() {
        if (this.starting.get()) {
            return;
        }
        if (!this.starting.compareAndSet(false, true)) {
            return;
        }
        this.clientUserChannel.startup();
        InternalKit.execute(this::extracted);
    }

    private void extracted() {
        if (ClientUserConfigs.closeScanner) {
            return;
        }
        String input = "";
        while (!input.equalsIgnoreCase("q")) {
            System.out.println("\u63d0\u793a\uff1a[\u547d\u4ee4\u6267\u884c : cmd-subCmd] [\u9000\u51fa : q] [\u5e2e\u52a9 : help]");
            try {
                input = ScannerKit.nextLine();
                input = input.trim();
            }
            catch (Exception e) {
                log.info("\u5728\u538b\u6d4b\u4e0b\uff0c\u5efa\u8bae\u5c06 ScannerKit.closeScanner \u8bbe\u7f6e\u4e3a true\uff0c\u5173\u95ed\u63a7\u5236\u53f0\u8f93\u5165\uff01");
                log.error(e.getMessage(), (Throwable)e);
                break;
            }
            if (StrKit.isEmpty((String)input)) continue;
            if (Objects.equals(input, "help") || Objects.equals(input, ".")) {
                this.help();
                continue;
            }
            if (Objects.equals(input, "..")) {
                this.listenHelp();
                continue;
            }
            if (Objects.equals(input, "...")) {
                this.help();
                this.listenHelp();
                continue;
            }
            if (Objects.equals(input, "q")) {
                System.out.println("88\uff0c\u8001\u54e5\uff01\u987a\u4fbf\u5e2e\u5fd9\u5173\u6ce8\u4e00\u4e0b\u7ec4\u7ec7 https://github.com/game-town");
                System.exit(-1);
                continue;
            }
            this.request(input);
        }
    }

    public ClientUserChannel getClientUserChannel() {
        return this.clientUserChannel;
    }
}

