/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.user;

import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.common.kit.ExecutorKit;
import com.iohao.game.common.kit.StrKit;
import com.iohao.game.external.client.command.CommandCallback;
import com.iohao.game.external.client.command.CommandRequest;
import com.iohao.game.external.client.command.InputCallback;
import com.iohao.game.external.client.command.InputCommand;
import com.iohao.game.external.client.command.ListenBroadcastCommand;
import com.iohao.game.external.client.kit.ClientKit;
import com.iohao.game.external.client.kit.ClientUserConfigs;
import com.iohao.game.external.client.user.ClientChannelRead;
import com.iohao.game.external.client.user.ClientUserInputCommands;
import com.iohao.game.external.client.user.DefaultClientUser;
import com.iohao.game.external.core.kit.ExternalKit;
import com.iohao.game.external.core.message.ExternalMessage;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jctools.maps.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUserChannel {
    private static final Logger log = LoggerFactory.getLogger(ClientUserChannel.class);
    private final AtomicInteger msgIdSeq = new AtomicInteger(1);
    private final AtomicBoolean starting = new AtomicBoolean();
    private final Map<Integer, ListenBroadcastCommand> listenBroadcastMap = new LinkedHashMap<Integer, ListenBroadcastCommand>();
    private final BlockingQueue<CommandRequest> blockingQueue = new LinkedBlockingQueue<CommandRequest>();
    private final Map<Integer, CommandCallback> callbackMap = new NonBlockingHashMap();
    private ClientChannelRead channelRead = new DefaultChannelRead();
    private final DefaultClientUser clientUser;
    public Consumer<ExternalMessage> clientChannel;
    public InetSocketAddress inetSocketAddress;

    public ClientUserChannel(DefaultClientUser clientUser) {
        this.clientUser = clientUser;
    }

    public void request(InputCommand inputCommand) {
        CmdInfo cmdInfo = inputCommand.getCmdInfo();
        Object requestData = inputCommand.getRequestData();
        Class<?> responseClass = inputCommand.getResponseClass();
        InputCallback callback = inputCommand.getCallback();
        this.request(cmdInfo, requestData, responseClass, callback);
    }

    public void request(CmdInfo cmdInfo, Object requestData, Class<?> responseClass, InputCallback callback) {
        int msgId = this.msgIdSeq.incrementAndGet();
        ExternalMessage externalMessage = ExternalKit.createExternalMessage((CmdInfo)cmdInfo, (Object)requestData);
        externalMessage.setMsgId(msgId);
        CommandRequest commandRequest = new CommandRequest(msgId, externalMessage);
        this.blockingQueue.add(commandRequest);
        CommandCallback commandCallback = new CommandCallback();
        commandCallback.msgId = msgId;
        commandCallback.responseClass = responseClass;
        commandCallback.callback = callback;
        commandCallback.requestData = requestData;
        this.callbackMap.put(msgId, commandCallback);
    }

    public void read(ExternalMessage externalMessage, BarSkeleton barSkeleton) {
        this.channelRead.read(externalMessage, barSkeleton);
    }

    void startup() {
        if (this.starting.get()) {
            return;
        }
        if (!this.starting.compareAndSet(false, true)) {
            return;
        }
        String simpleName = this.getClass().getSimpleName();
        ExecutorKit.newSingleThreadExecutor((String)simpleName).execute(() -> {
            while (true) {
                try {
                    while (true) {
                        CommandRequest commandRequest = this.blockingQueue.take();
                        if (ClientUserConfigs.openLogRequestCommand) {
                            long userId = this.clientUser.getUserId();
                            ExternalMessage externalMessage = commandRequest.externalMessage();
                            CmdInfo cmdInfo = CmdInfo.getCmdInfo((int)externalMessage.getCmdMerge());
                            ClientUserInputCommands inputCommands = this.clientUser.getClientUserInputCommands();
                            InputCommand inputCommand = inputCommands.getInputCommand(cmdInfo);
                            log.info("\u73a9\u5bb6[{}] \u5411\u670d\u52a1\u5668\u53d1\u9001\u8bf7\u6c42 \u3010{}\u3011", (Object)userId, (Object)inputCommand);
                        }
                        this.writeAndFlush(commandRequest);
                    }
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        });
    }

    private void writeAndFlush(CommandRequest clientRequest) {
        ExternalMessage externalMessage = clientRequest.externalMessage();
        this.writeAndFlush(externalMessage);
    }

    public void writeAndFlush(ExternalMessage externalMessage) {
        if (Objects.isNull(this.clientChannel)) {
            return;
        }
        InetSocketAddress inetSocketAddress = this.inetSocketAddress;
        if (Objects.nonNull(inetSocketAddress)) {
            externalMessage.setOther((Object)inetSocketAddress);
        }
        this.clientChannel.accept(externalMessage);
    }

    public void listenBroadcast(CmdInfo cmdInfo, Class<?> responseClass, InputCallback callback, String description) {
        CommandCallback commandCallback = new CommandCallback();
        commandCallback.responseClass = responseClass;
        commandCallback.callback = callback;
        int cmdMerge = cmdInfo.getCmdMerge();
        if (this.listenBroadcastMap.containsKey(cmdMerge)) {
            throw new RuntimeException("\u76f8\u540c\u7684\u5e7f\u64ad\u8def\u7531\uff0c\u53ea\u80fd\u76d1\u542c\u4e00\u4e2a");
        }
        ListenBroadcastCommand broadcastCommand = new ListenBroadcastCommand(cmdInfo);
        broadcastCommand.setCommandCallback(commandCallback);
        if (StrKit.isNotEmpty((String)description)) {
            broadcastCommand.setDescription(description);
        }
        this.listenBroadcastMap.put(cmdMerge, broadcastCommand);
    }

    public AtomicInteger getMsgIdSeq() {
        return this.msgIdSeq;
    }

    public AtomicBoolean getStarting() {
        return this.starting;
    }

    public Map<Integer, ListenBroadcastCommand> getListenBroadcastMap() {
        return this.listenBroadcastMap;
    }

    public BlockingQueue<CommandRequest> getBlockingQueue() {
        return this.blockingQueue;
    }

    public Map<Integer, CommandCallback> getCallbackMap() {
        return this.callbackMap;
    }

    public ClientChannelRead getChannelRead() {
        return this.channelRead;
    }

    public DefaultClientUser getClientUser() {
        return this.clientUser;
    }

    public Consumer<ExternalMessage> getClientChannel() {
        return this.clientChannel;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSocketAddress;
    }

    public void setChannelRead(ClientChannelRead channelRead) {
        this.channelRead = channelRead;
    }

    public void setClientChannel(Consumer<ExternalMessage> clientChannel) {
        this.clientChannel = clientChannel;
    }

    public void setInetSocketAddress(InetSocketAddress inetSocketAddress) {
        this.inetSocketAddress = inetSocketAddress;
    }

    class DefaultChannelRead
    implements ClientChannelRead {
        DefaultChannelRead() {
        }

        @Override
        public void read(ExternalMessage externalMessage, BarSkeleton barSkeleton) {
            CommandCallback commandCallback;
            int responseStatus = externalMessage.getResponseStatus();
            int cmdMerge = externalMessage.getCmdMerge();
            CmdInfo cmdInfo = CmdInfo.getCmdInfo((int)cmdMerge);
            if (responseStatus != 0) {
                log.error("\u9519\u8bef\u7801:{} {} {}", new Object[]{responseStatus, externalMessage.getValidMsg(), cmdInfo});
                return;
            }
            if (externalMessage.getCmdCode() == 0) {
                if (ClientUserConfigs.openLogIdle) {
                    log.info("\u63a5\u6536\u670d\u52a1\u5668\u5fc3\u8df3\u56de\u8c03 : {}", (Object)externalMessage);
                }
                return;
            }
            int msgId = externalMessage.getMsgId();
            if (msgId != 0 && Objects.nonNull(commandCallback = ClientUserChannel.this.callbackMap.get(msgId))) {
                if (ClientUserConfigs.openLogRequestCallback) {
                    long userId = ClientUserChannel.this.clientUser.getUserId();
                    ClientUserInputCommands inputCommands = ClientUserChannel.this.clientUser.getClientUserInputCommands();
                    InputCommand inputCommand = inputCommands.getInputCommand(cmdInfo);
                    log.info("\u73a9\u5bb6[{}] \u7684\u8bf7\u6c42\u56de\u8c03\u3010{}\u3011", (Object)userId, (Object)inputCommand);
                }
                commandCallback.callback(externalMessage);
                return;
            }
            ListenBroadcastCommand broadcastCommand = ClientUserChannel.this.listenBroadcastMap.get(cmdMerge);
            if (Objects.nonNull(broadcastCommand)) {
                if (ClientUserConfigs.openLogListenBroadcast) {
                    log.info("\u89e6\u53d1\u5e7f\u64ad\u76d1\u542c\u56de\u8c03 : {}", (Object)broadcastCommand);
                }
                CommandCallback commandCallback2 = broadcastCommand.getCommandCallback();
                commandCallback2.callback(externalMessage);
                return;
            }
            if (ClientUserConfigs.openLogAction) {
                String inputName = ClientKit.toInputName(cmdInfo);
                log.info("action : {}", (Object)inputName);
            }
        }
    }
}

