/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.join;

import com.iohao.game.common.kit.ExecutorKit;
import com.iohao.game.common.kit.InternalKit;
import com.iohao.game.common.kit.PresentKit;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import com.iohao.game.external.client.ClientConnectOption;
import com.iohao.game.external.client.InputCommandRegion;
import com.iohao.game.external.client.join.ClientConnect;
import com.iohao.game.external.client.join.ClientConnects;
import com.iohao.game.external.client.user.ClientUser;
import com.iohao.game.external.client.user.ClientUserChannel;
import com.iohao.game.external.client.user.ClientUsers;
import com.iohao.game.external.client.user.DefaultClientUser;
import com.iohao.game.external.core.config.ExternalGlobalConfig;
import com.iohao.game.external.core.config.ExternalJoinEnum;
import com.iohao.game.external.core.message.ExternalMessage;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public final class ClientRunOne {
    static final Logger log = IoGameLoggerFactory.getLoggerCommonStdout();
    private List<InputCommandRegion> inputCommandRegions;
    private ClientUser clientUser;
    private int connectPort = 10100;
    private String connectAddress = "127.0.0.1";
    private String websocketPath = ExternalGlobalConfig.CoreOption.websocketPath;
    private ExternalJoinEnum joinEnum = ExternalJoinEnum.WEBSOCKET;
    private ClientConnectOption option;

    public void startup() {
        if (Objects.isNull(this.clientUser)) {
            this.clientUser = new DefaultClientUser();
        }
        Objects.requireNonNull(this.inputCommandRegions, "\u8bf7\u8bbe\u7f6e\u9700\u8981\u53d1\u9001\u7684\u8bf7\u6c42\u6d88\u606f");
        ClientUsers.addClientUser(this.clientUser);
        this.inputCommandRegions.forEach(inputCommandRegion -> {
            inputCommandRegion.setClientUser(this.clientUser);
            inputCommandRegion.initInputCommand();
        });
        ClientConnectOption option = this.getOption();
        ClientConnect clientConnect = ClientConnects.getClientConnect(this.joinEnum);
        if (Objects.isNull(clientConnect)) {
            log.error("\u8fde\u63a5\u65b9\u5f0f {} \u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b", (Object)this.joinEnum);
            return;
        }
        InternalKit.execute(() -> clientConnect.connect(option));
        try {
            log.info("\u542f\u52a8\u6210\u529f");
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ClientRunOne idle(int idlePeriod) {
        ExecutorKit.newSingleScheduled((String)"idle").scheduleAtFixedRate(() -> {
            ExternalMessage externalMessage = new ExternalMessage();
            externalMessage.setCmdCode(0);
            ClientUserChannel clientUserChannel = this.clientUser.getClientUserChannel();
            clientUserChannel.writeAndFlush(externalMessage);
        }, 1L, idlePeriod, TimeUnit.SECONDS);
        return this;
    }

    private ClientConnectOption getOption() {
        if (Objects.isNull(this.option)) {
            this.option = new ClientConnectOption();
        }
        PresentKit.ifNull((Object)this.option.getWsUrl(), () -> {
            String wsUrl = String.format("ws://%s:%d%s", this.connectAddress, this.connectPort, this.websocketPath);
            this.option.setWsUrl(wsUrl);
        });
        PresentKit.ifNull((Object)this.option.getSocketAddress(), () -> {
            InetSocketAddress socketAddress = new InetSocketAddress(this.connectAddress, this.connectPort);
            this.option.setSocketAddress(socketAddress);
        });
        PresentKit.ifNull((Object)this.option.getClientUser(), () -> this.option.setClientUser(this.clientUser));
        return this.option;
    }

    public List<InputCommandRegion> getInputCommandRegions() {
        return this.inputCommandRegions;
    }

    public ClientUser getClientUser() {
        return this.clientUser;
    }

    public int getConnectPort() {
        return this.connectPort;
    }

    public String getConnectAddress() {
        return this.connectAddress;
    }

    public String getWebsocketPath() {
        return this.websocketPath;
    }

    public ExternalJoinEnum getJoinEnum() {
        return this.joinEnum;
    }

    public ClientRunOne setInputCommandRegions(List<InputCommandRegion> inputCommandRegions) {
        this.inputCommandRegions = inputCommandRegions;
        return this;
    }

    public ClientRunOne setClientUser(ClientUser clientUser) {
        this.clientUser = clientUser;
        return this;
    }

    public ClientRunOne setConnectPort(int connectPort) {
        this.connectPort = connectPort;
        return this;
    }

    public ClientRunOne setConnectAddress(String connectAddress) {
        this.connectAddress = connectAddress;
        return this;
    }

    public ClientRunOne setWebsocketPath(String websocketPath) {
        this.websocketPath = websocketPath;
        return this;
    }

    public ClientRunOne setJoinEnum(ExternalJoinEnum joinEnum) {
        this.joinEnum = joinEnum;
        return this;
    }

    public ClientRunOne setOption(ClientConnectOption option) {
        this.option = option;
        return this;
    }
}

