/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.client.command;

import com.iohao.game.action.skeleton.core.CmdInfo;
import com.iohao.game.external.client.command.InputCallback;
import com.iohao.game.external.client.command.InputRequestData;
import com.iohao.game.external.client.kit.ClientKit;
import java.util.Objects;

public class InputCommand {
    private final String inputName;
    private final CmdInfo cmdInfo;
    private String description = "... ...";
    private Object requestData;
    private InputRequestData inputRequestData;
    private InputCallback callback;
    private Class<?> responseClass;

    public InputCommand(CmdInfo cmdInfo) {
        this.inputName = ClientKit.toInputName(cmdInfo);
        this.cmdInfo = cmdInfo;
    }

    public InputCommand callback(Class<?> responseClass, InputCallback callback) {
        this.callback = callback;
        if (Objects.nonNull(responseClass)) {
            this.responseClass = responseClass;
        }
        return this;
    }

    public Object getRequestData() {
        if (Objects.nonNull(this.inputRequestData)) {
            return this.inputRequestData.createRequestData();
        }
        return this.requestData;
    }

    public String toString() {
        return this.inputName + "    :    " + this.description;
    }

    public String getInputName() {
        return this.inputName;
    }

    public CmdInfo getCmdInfo() {
        return this.cmdInfo;
    }

    public String getDescription() {
        return this.description;
    }

    public InputRequestData getInputRequestData() {
        return this.inputRequestData;
    }

    public InputCallback getCallback() {
        return this.callback;
    }

    public Class<?> getResponseClass() {
        return this.responseClass;
    }

    public InputCommand setDescription(String description) {
        this.description = description;
        return this;
    }

    public InputCommand setRequestData(Object requestData) {
        this.requestData = requestData;
        return this;
    }

    public InputCommand setInputRequestData(InputRequestData inputRequestData) {
        this.inputRequestData = inputRequestData;
        return this;
    }

    public InputCommand setResponseClass(Class<?> responseClass) {
        this.responseClass = responseClass;
        return this;
    }

    private InputCommand setCallback(InputCallback callback) {
        this.callback = callback;
        return this;
    }
}

