/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.session;

import com.iohao.game.common.kit.concurrent.executor.ExecutorRegionKit;
import com.iohao.game.external.core.netty.session.AbstractUserSessions;
import com.iohao.game.external.core.netty.session.SocketUserSession;
import com.iohao.game.external.core.session.UserChannelId;
import com.iohao.game.external.core.session.UserSessionState;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Objects;

public final class SocketUserSessions
extends AbstractUserSessions<ChannelHandlerContext, SocketUserSession> {
    static final AttributeKey<SocketUserSession> userSessionKey = AttributeKey.valueOf((String)"userSession");
    private final ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public SocketUserSession add(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        SocketUserSession userSession = new SocketUserSession(channel);
        userSession.cmdRegions = this.cmdRegions;
        channel.attr(userSessionKey).set((Object)userSession);
        UserChannelId userChannelId = userSession.getUserChannelId();
        this.userChannelIdMap.putIfAbsent(userChannelId, userSession);
        this.channelGroup.add((Object)channel);
        this.settingDefault(userSession);
        return userSession;
    }

    public SocketUserSession getUserSession(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        return (SocketUserSession)channel.attr(userSessionKey).get();
    }

    public boolean settingUserId(UserChannelId userChannelId, long userId) {
        SocketUserSession userSession = (SocketUserSession)this.getUserSession(userChannelId);
        if (Objects.isNull(userSession)) {
            return false;
        }
        if (Boolean.FALSE.equals(userSession.isActive())) {
            this.removeUserSession(userSession);
            return false;
        }
        userSession.setUserId(userId);
        this.userIdMap.put(userId, (Object)userSession);
        if (userSession.isVerifyIdentity()) {
            this.userHookInto(userSession);
        }
        return true;
    }

    public void removeUserSession(SocketUserSession userSession) {
        if (Objects.isNull(userSession)) {
            return;
        }
        long userId = userSession.getUserId();
        ExecutorRegionKit.getSimpleThreadExecutor((long)userId).executeTry(() -> this.internalRemoveUserSession(userSession));
    }

    private void internalRemoveUserSession(SocketUserSession userSession) {
        if (userSession.getState() == UserSessionState.DEAD) {
            this.removeUserSessionMap(userSession);
            return;
        }
        if (userSession.getState() == UserSessionState.ACTIVE && userSession.isVerifyIdentity()) {
            userSession.setState(UserSessionState.DEAD);
            this.userHookQuit(userSession);
        }
        this.removeUserSessionMap(userSession);
        userSession.getChannel().close();
    }

    private void removeUserSessionMap(SocketUserSession userSession) {
        Channel channel;
        long userId = userSession.getUserId();
        this.userIdMap.remove(userId);
        UserChannelId userChannelId = userSession.getUserChannelId();
        if (Objects.nonNull(userChannelId)) {
            this.userChannelIdMap.remove(userChannelId);
        }
        if (Objects.nonNull(channel = userSession.getChannel())) {
            this.channelGroup.remove((Object)channel);
        }
    }

    public int countOnline() {
        return this.channelGroup.size();
    }

    public void broadcast(Object msg) {
        this.channelGroup.writeAndFlush(msg);
    }
}

