/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.session;

import com.iohao.game.external.core.netty.session.AbstractUserSession;
import com.iohao.game.external.core.session.UserChannelId;
import com.iohao.game.external.core.session.UserSessionOption;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.Objects;

public final class SocketUserSession
extends AbstractUserSession {
    public SocketUserSession(Channel channel) {
        this.channel = channel;
        String channelId = this.channel.id().asLongText();
        this.userChannelId = new UserChannelId(channelId);
    }

    @Override
    public boolean isActive() {
        return Objects.nonNull(this.channel) && this.channel.isActive();
    }

    public ChannelFuture writeAndFlush(Object message) {
        return this.channel.writeAndFlush(message);
    }

    public String getIp() {
        String realIp = (String)this.option(UserSessionOption.realIp);
        if (realIp.isEmpty()) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.channel.remoteAddress();
            return inetSocketAddress.getHostString();
        }
        return realIp;
    }
}

