/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.session;

import com.iohao.game.bolt.broker.core.aware.CmdRegionsAware;
import com.iohao.game.common.kit.attr.AttrOptions;
import com.iohao.game.core.common.cmd.CmdRegions;
import com.iohao.game.external.core.config.ExternalJoinEnum;
import com.iohao.game.external.core.hook.UserHook;
import com.iohao.game.external.core.session.UserChannelId;
import com.iohao.game.external.core.session.UserSession;
import com.iohao.game.external.core.session.UserSessionOption;
import com.iohao.game.external.core.session.UserSessions;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jctools.maps.NonBlockingHashMap;
import org.jctools.maps.NonBlockingHashMapLong;

abstract class AbstractUserSessions<ChannelHandlerContext, Session extends UserSession>
implements UserSessions<ChannelHandlerContext, Session>,
CmdRegionsAware {
    protected final AttrOptions options = new AttrOptions();
    protected final NonBlockingHashMapLong<Session> userIdMap = new NonBlockingHashMapLong();
    protected final Map<UserChannelId, Session> userChannelIdMap = new NonBlockingHashMap();
    protected CmdRegions cmdRegions;
    protected UserHook userHook;

    AbstractUserSessions() {
    }

    public boolean existUserSession(long userId) {
        return this.userIdMap.containsKey(userId);
    }

    public Session getUserSession(long userId) {
        return (Session)((UserSession)this.userIdMap.get(userId));
    }

    public Session getUserSession(UserChannelId userChannelId) {
        return (Session)((UserSession)this.userChannelIdMap.get(userChannelId));
    }

    public void removeUserSession(long userId, Object msg) {
        this.ifPresent(userId, userSession -> {
            ChannelFuture channelFuture = (ChannelFuture)userSession.writeAndFlush(msg);
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> this.removeUserSession((UserSession)userSession)));
        });
    }

    public void forEach(Consumer<Session> consumer) {
        this.userChannelIdMap.values().forEach(consumer);
    }

    void userHookInto(UserSession userSession) {
        if (Objects.isNull(this.userHook)) {
            return;
        }
        this.userHook.into(userSession);
    }

    void userHookQuit(UserSession userSession) {
        if (Objects.isNull(this.userHook)) {
            return;
        }
        this.userHook.quit(userSession);
    }

    void settingDefault(UserSession userSession) {
        ExternalJoinEnum externalJoinEnum = (ExternalJoinEnum)this.option(UserSessionOption.externalJoin);
        userSession.option(UserSessionOption.externalJoin, (Object)externalJoinEnum);
    }

    public AttrOptions getOptions() {
        return this.options;
    }

    public void setCmdRegions(CmdRegions cmdRegions) {
        this.cmdRegions = cmdRegions;
    }

    public void setUserHook(UserHook userHook) {
        this.userHook = userHook;
    }
}

