/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.session;

import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.common.kit.attr.AttrOptions;
import com.iohao.game.core.common.cmd.CmdRegions;
import com.iohao.game.external.core.session.UserChannelId;
import com.iohao.game.external.core.session.UserSession;
import com.iohao.game.external.core.session.UserSessionOption;
import com.iohao.game.external.core.session.UserSessionState;
import io.netty.channel.Channel;
import java.util.Objects;
import org.jctools.maps.NonBlockingHashSet;

abstract class AbstractUserSession
implements UserSession {
    protected final AttrOptions options = new AttrOptions();
    protected Channel channel;
    protected long userId;
    protected UserChannelId userChannelId;
    protected CmdRegions cmdRegions;
    protected int externalClientId;
    protected UserSessionState state = UserSessionState.ACTIVE;

    AbstractUserSession() {
        this.option(UserSessionOption.verifyIdentity, false);
        this.option(UserSessionOption.bindingLogicServerIdSet, new NonBlockingHashSet());
    }

    public void employ(BarMessage requestMessage) {
        HeadMetadata headMetadata = requestMessage.getHeadMetadata();
        this.employ(headMetadata);
    }

    public void employ(HeadMetadata headMetadata) {
        headMetadata.setUserId(this.userId);
        headMetadata.setSourceClientId(this.externalClientId);
        this.ifPresent(UserSessionOption.externalJoin, externalJoin -> headMetadata.setStick(externalJoin.getIndex()));
        if (!this.isVerifyIdentity()) {
            String channelId = this.userChannelId.channelId();
            headMetadata.setChannelId(channelId);
        }
        this.ifPresent(UserSessionOption.bindingLogicServerIdArray, arg_0 -> ((HeadMetadata)headMetadata).setBindingLogicServerIds(arg_0));
        if (Objects.isNull(headMetadata.getAttachmentData())) {
            this.ifPresent(UserSessionOption.attachment, arg_0 -> ((HeadMetadata)headMetadata).setAttachmentData(arg_0));
        }
    }

    public void setUserId(long userId) {
        this.userId = userId;
        this.option(UserSessionOption.verifyIdentity, true);
    }

    public boolean isVerifyIdentity() {
        return (Boolean)this.optionValue(UserSessionOption.verifyIdentity, false);
    }

    public boolean isActive() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractUserSession)) {
            return false;
        }
        AbstractUserSession that = (AbstractUserSession)o;
        return Objects.equals(this.userChannelId, that.userChannelId);
    }

    public int hashCode() {
        return this.userChannelId.hashCode();
    }

    public AttrOptions getOptions() {
        return this.options;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public long getUserId() {
        return this.userId;
    }

    public UserChannelId getUserChannelId() {
        return this.userChannelId;
    }

    public CmdRegions getCmdRegions() {
        return this.cmdRegions;
    }

    public int getExternalClientId() {
        return this.externalClientId;
    }

    public UserSessionState getState() {
        return this.state;
    }

    public void setExternalClientId(int externalClientId) {
        this.externalClientId = externalClientId;
    }

    public void setState(UserSessionState state) {
        this.state = state;
    }
}

