/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.micro;

import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.external.core.config.ExternalGlobalConfig;
import com.iohao.game.external.core.micro.PipelineContext;
import com.iohao.game.external.core.netty.handler.codec.WebSocketExternalCodec;
import com.iohao.game.external.core.netty.handler.ws.WebSocketVerifyHandler;
import com.iohao.game.external.core.netty.micro.SocketMicroBootstrapFlow;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import java.util.Objects;

public class WebSocketMicroBootstrapFlow
extends SocketMicroBootstrapFlow {
    public void option(ServerBootstrap bootstrap) {
        ((ServerBootstrap)bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true).option(ChannelOption.SO_BACKLOG, (Object)100)).childOption(ChannelOption.SO_REUSEADDR, (Object)true);
    }

    public void pipelineCodec(PipelineContext context) {
        this.httpHandler(context);
        this.verifyHandler(context);
        this.websocketHandler(context);
        MessageToMessageCodec<BinaryWebSocketFrame, BarMessage> externalCodec = this.createExternalCodec();
        context.addLast("codec", externalCodec);
    }

    protected MessageToMessageCodec<BinaryWebSocketFrame, BarMessage> createExternalCodec() {
        return new WebSocketExternalCodec();
    }

    protected void verifyHandler(PipelineContext context) {
        WebSocketVerifyHandler verifyHandler = this.createVerifyHandler();
        if (Objects.nonNull((Object)verifyHandler)) {
            context.addLast("WebSocketVerifyHandler", (Object)verifyHandler);
        }
    }

    protected WebSocketVerifyHandler createVerifyHandler() {
        return null;
    }

    protected void websocketHandler(PipelineContext context) {
        context.addLast("compression", (Object)new WebSocketServerCompressionHandler());
        WebSocketServerProtocolConfig config = WebSocketServerProtocolConfig.newBuilder().websocketPath(ExternalGlobalConfig.CoreOption.websocketPath).maxFramePayloadLength(ExternalGlobalConfig.CoreOption.packageMaxSize).checkStartsWith(true).allowExtensions(true).build();
        context.addLast("WebSocketServerProtocolHandler", (Object)new WebSocketServerProtocolHandler(config));
    }

    protected void httpHandler(PipelineContext context) {
        context.addLast("http-codec", (Object)new HttpServerCodec());
        context.addLast("aggregator", (Object)new HttpObjectAggregator(65536));
    }
}

