/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.micro;

import com.iohao.game.external.core.config.ExternalGlobalConfig;
import com.iohao.game.external.core.hook.internal.IdleProcessSetting;
import com.iohao.game.external.core.micro.PipelineContext;
import com.iohao.game.external.core.netty.SettingOption;
import com.iohao.game.external.core.netty.handler.CmdCacheHandler;
import com.iohao.game.external.core.netty.handler.CmdCheckHandler;
import com.iohao.game.external.core.netty.handler.SimpleLoggerHandler;
import com.iohao.game.external.core.netty.handler.SocketCmdAccessAuthHandler;
import com.iohao.game.external.core.netty.handler.SocketIdleHandler;
import com.iohao.game.external.core.netty.handler.SocketRequestBrokerHandler;
import com.iohao.game.external.core.netty.handler.SocketUserSessionHandler;
import com.iohao.game.external.core.netty.micro.AbstractMicroBootstrapFlow;
import com.iohao.game.external.core.netty.micro.DefaultPipelineContext;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Objects;

abstract class SocketMicroBootstrapFlow
extends AbstractMicroBootstrapFlow<ServerBootstrap> {
    SocketMicroBootstrapFlow() {
    }

    public void channelInitializer(ServerBootstrap bootstrap) {
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                DefaultPipelineContext pipelineContext = new DefaultPipelineContext((Channel)ch, SocketMicroBootstrapFlow.this.setting);
                SocketMicroBootstrapFlow.this.pipelineFlow(pipelineContext);
            }
        });
    }

    public void pipelineIdle(PipelineContext context) {
        IdleProcessSetting idleProcessSetting = this.setting.getIdleProcessSetting();
        if (Objects.isNull(idleProcessSetting)) {
            return;
        }
        context.addLast("idleStateHandler", (Object)new IdleStateHandler(idleProcessSetting.getReaderIdleTime(), idleProcessSetting.getWriterIdleTime(), idleProcessSetting.getAllIdleTime(), idleProcessSetting.getTimeUnit()));
        SocketIdleHandler socketIdleHandler = (SocketIdleHandler)((Object)this.setting.option(SettingOption.socketIdleHandler));
        context.addLast("idleHandler", (Object)socketIdleHandler);
    }

    public void pipelineCustom(PipelineContext context) {
        if (ExternalGlobalConfig.enableLoggerHandler) {
            context.addLast("SimpleLoggerHandler", (Object)SimpleLoggerHandler.me());
        }
        context.addLast("CmdCheckHandler", (Object)CmdCheckHandler.me());
        SocketUserSessionHandler socketUserSessionHandler = (SocketUserSessionHandler)((Object)this.setting.option(SettingOption.socketUserSessionHandler));
        context.addLast("UserSessionHandler", (Object)socketUserSessionHandler);
        SocketCmdAccessAuthHandler socketCmdAccessAuthHandler = (SocketCmdAccessAuthHandler)((Object)this.setting.option(SettingOption.socketCmdAccessAuthHandler));
        context.addLast("CmdAccessAuthHandler", (Object)socketCmdAccessAuthHandler);
        if (Objects.nonNull(ExternalGlobalConfig.externalCmdCache)) {
            context.addLast("CmdCacheHandler", (Object)CmdCacheHandler.me());
        }
        SocketRequestBrokerHandler socketRequestBrokerHandler = (SocketRequestBrokerHandler)((Object)this.setting.option(SettingOption.socketRequestBrokerHandler));
        context.addLast("RequestBrokerHandler", (Object)socketRequestBrokerHandler);
    }
}

