/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.micro;

import com.iohao.game.action.skeleton.toy.IoGameBanner;
import com.iohao.game.common.kit.system.OsInfo;
import com.iohao.game.external.core.micro.MicroBootstrapFlow;
import com.iohao.game.external.core.netty.micro.AbstractMicroBootstrap;
import com.iohao.game.external.core.netty.micro.auto.GroupChannelOption;
import com.iohao.game.external.core.netty.micro.auto.GroupChannelOptionForLinux;
import com.iohao.game.external.core.netty.micro.auto.GroupChannelOptionForMac;
import com.iohao.game.external.core.netty.micro.auto.GroupChannelOptionForOther;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketMicroBootstrap
extends AbstractMicroBootstrap {
    private static final Logger log = LoggerFactory.getLogger((String)"ExternalTopic");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        GroupChannelOption groupChannelOption = this.createGroupChannelOption();
        EventLoopGroup bossGroup = groupChannelOption.bossGroup();
        EventLoopGroup workerGroup = groupChannelOption.workerGroup();
        Class<? extends ServerChannel> channelClass = groupChannelOption.channelClass();
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(channelClass);
        MicroBootstrapFlow microBootstrapFlow = this.setting.getMicroBootstrapFlow();
        microBootstrapFlow.createFlow((Object)bootstrap);
        int externalCorePort = this.setting.getExternalCorePort();
        ChannelFuture channelFuture = bootstrap.bind(externalCorePort);
        try {
            IoGameBanner.render();
            channelFuture.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    private GroupChannelOption createGroupChannelOption() {
        GroupChannelOption groupChannelOption = OsInfo.isLinux() ? new GroupChannelOptionForLinux() : (OsInfo.isMac() ? new GroupChannelOptionForMac() : new GroupChannelOptionForOther());
        return groupChannelOption;
    }
}

