/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.hook;

import com.iohao.game.action.skeleton.core.exception.ActionErrorEnum;
import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.external.core.message.ExternalCodecKit;
import com.iohao.game.external.core.netty.hook.SocketIdleHook;
import com.iohao.game.external.core.session.UserSession;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSocketIdleHook
implements SocketIdleHook {
    private static final Logger log = LoggerFactory.getLogger((String)"CommonStdout");

    public boolean callback(UserSession userSession, IdleStateEvent event) {
        IdleState state = event.state();
        if (state == IdleState.READER_IDLE) {
            log.debug("READER_IDLE \u8bfb\u8d85\u65f6");
        } else if (state == IdleState.WRITER_IDLE) {
            log.debug("WRITER_IDLE \u5199\u8d85\u65f6");
        } else if (state == IdleState.ALL_IDLE) {
            log.debug("ALL_IDLE \u603b\u8d85\u65f6");
        }
        BarMessage message = ExternalCodecKit.createErrorIdleMessage((ActionErrorEnum)ActionErrorEnum.idleErrorCode);
        message.setValidatorMsg(ActionErrorEnum.idleErrorCode.getMsg() + " : " + state.name());
        userSession.writeAndFlush((Object)message);
        return true;
    }
}

