/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.handler.ws;

import com.iohao.game.external.core.aware.UserSessionsAware;
import com.iohao.game.external.core.netty.session.SocketUserSession;
import com.iohao.game.external.core.netty.session.SocketUserSessions;
import com.iohao.game.external.core.session.UserSessions;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WebSocketVerifyHandler
extends ChannelInboundHandlerAdapter
implements UserSessionsAware {
    protected SocketUserSessions userSessions;

    public void setUserSessions(UserSessions<?, ?> userSessions) {
        this.userSessions = (SocketUserSessions)userSessions;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)msg;
            String uri = request.uri();
            Map<String, String> params = this.getParams(uri);
            SocketUserSession userSession = this.userSessions.getUserSession(ctx);
            boolean verify = this.verify(userSession, params);
            if (verify) {
                ctx.pipeline().remove((ChannelHandler)this);
            } else {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
                ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
        }
        super.channelRead(ctx, msg);
    }

    protected boolean verify(SocketUserSession userSession, Map<String, String> params) {
        return true;
    }

    protected Map<String, String> getParams(String uri) {
        return new QueryStringDecoder(uri).parameters().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((List)entry.getValue()).getFirst()));
    }
}

