/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.handler.ws;

import com.iohao.game.external.core.aware.UserSessionsAware;
import com.iohao.game.external.core.netty.session.SocketUserSessions;
import com.iohao.game.external.core.session.UserSessionOption;
import com.iohao.game.external.core.session.UserSessions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpRealIpHandler
extends ChannelInboundHandlerAdapter
implements UserSessionsAware {
    private static final Logger log = LoggerFactory.getLogger(HttpRealIpHandler.class);
    SocketUserSessions userSessions;

    public void setUserSessions(UserSessions<?, ?> userSessions) {
        this.userSessions = (SocketUserSessions)userSessions;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)msg;
            HttpHeaders headers = request.headers();
            String realIp = headers.get("X-Real-IP");
            Optional.ofNullable(this.userSessions.getUserSession(ctx)).ifPresent(session -> session.option(UserSessionOption.realIp, realIp));
            ctx.pipeline().remove((ChannelHandler)this);
        }
        super.channelRead(ctx, msg);
    }
}

