/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.handler.codec;

import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.external.core.message.ExternalCodecKit;
import com.iohao.game.external.core.message.ExternalMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.util.List;

public class WebSocketExternalCodec
extends MessageToMessageCodec<BinaryWebSocketFrame, BarMessage> {
    protected void encode(ChannelHandlerContext ctx, BarMessage message, List<Object> out) {
        ExternalMessage externalMessage = (ExternalMessage)ExternalCodecKit.convertExternalMessage((BarMessage)message);
        byte[] bytes = DataCodecKit.encode((Object)externalMessage);
        ByteBuf byteBuf = ctx.alloc().buffer(bytes.length);
        byteBuf.writeBytes(bytes);
        BinaryWebSocketFrame socketFrame = new BinaryWebSocketFrame(byteBuf);
        out.add(socketFrame);
    }

    protected void decode(ChannelHandlerContext ctx, BinaryWebSocketFrame binary, List<Object> out) {
        ByteBuf contentBuf = binary.content();
        byte[] bytes = new byte[contentBuf.readableBytes()];
        contentBuf.readBytes(bytes);
        ExternalMessage externalMessage = (ExternalMessage)DataCodecKit.decode((byte[])bytes, ExternalMessage.class);
        RequestMessage message = ExternalCodecKit.convertRequestMessage((Object)externalMessage);
        out.add(message);
    }
}

