/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.handler;

import com.iohao.game.bolt.broker.core.aware.BrokerClientAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessage;
import com.iohao.game.external.core.aware.UserSessionsAware;
import com.iohao.game.external.core.netty.session.SocketUserSession;
import com.iohao.game.external.core.netty.session.SocketUserSessions;
import com.iohao.game.external.core.session.UserSessions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class SocketUserSessionHandler
extends ChannelInboundHandlerAdapter
implements UserSessionsAware,
BrokerClientAware {
    private static final Logger log = LoggerFactory.getLogger((String)"ExternalTopic");
    SocketUserSessions userSessions;
    BrokerClient brokerClient;

    public void setUserSessions(UserSessions<?, ?> userSessions) {
        this.userSessions = (SocketUserSessions)userSessions;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        BrokerClientModuleMessage moduleMessage = this.brokerClient.getBrokerClientModuleMessage();
        int idHash = moduleMessage.getIdHash();
        SocketUserSession userSession = this.userSessions.add(ctx);
        userSession.setExternalClientId(idHash);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        SocketUserSession userSession = this.userSessions.getUserSession(ctx);
        this.userSessions.removeUserSession(userSession);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        SocketUserSession userSession = this.userSessions.getUserSession(ctx);
        this.userSessions.removeUserSession(userSession);
        super.exceptionCaught(ctx, cause);
    }

    public void setBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }
}

