/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.handler;

import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.action.skeleton.protocol.HeadMetadata;
import com.iohao.game.bolt.broker.core.aware.BrokerClientAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.common.kit.trace.TraceKit;
import com.iohao.game.external.core.aware.UserSessionsAware;
import com.iohao.game.external.core.netty.session.SocketUserSession;
import com.iohao.game.external.core.netty.session.SocketUserSessions;
import com.iohao.game.external.core.session.UserSessions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class SocketRequestBrokerHandler
extends SimpleChannelInboundHandler<BarMessage>
implements UserSessionsAware,
BrokerClientAware {
    private static final Logger log = LoggerFactory.getLogger((String)"ExternalTopic");
    BrokerClient brokerClient;
    SocketUserSessions userSessions;

    protected void channelRead0(ChannelHandlerContext ctx, BarMessage message) {
        SocketUserSession userSession = this.userSessions.getUserSession(ctx);
        userSession.employ(message);
        if (IoGameGlobalConfig.openTraceId) {
            HeadMetadata headMetadata = message.getHeadMetadata();
            headMetadata.setTraceId(TraceKit.newTraceId());
        }
        try {
            this.brokerClient.oneway((Object)message);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setUserSessions(UserSessions<?, ?> userSessions) {
        this.userSessions = (SocketUserSessions)userSessions;
    }

    public void setBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }
}

