/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.handler;

import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.external.core.ExternalCoreSetting;
import com.iohao.game.external.core.aware.ExternalCoreSettingAware;
import com.iohao.game.external.core.hook.IdleHook;
import com.iohao.game.external.core.hook.internal.IdleProcessSetting;
import com.iohao.game.external.core.netty.DefaultExternalCoreSetting;
import com.iohao.game.external.core.netty.session.SocketUserSession;
import com.iohao.game.external.core.session.UserSession;
import com.iohao.game.external.core.session.UserSessions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Objects;

@ChannelHandler.Sharable
public final class SocketIdleHandler
extends ChannelInboundHandlerAdapter
implements ExternalCoreSettingAware {
    IdleHook<IdleStateEvent> idleHook;
    boolean pong;
    UserSessions<ChannelHandlerContext, SocketUserSession> userSessions;

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        BarMessage message = (BarMessage)msg;
        int cmdCode = message.getHeadMetadata().getCmdCode();
        if (cmdCode != 0) {
            ctx.fireChannelRead(msg);
            return;
        }
        if (this.pong) {
            if (Objects.nonNull(this.idleHook)) {
                this.idleHook.pongBefore(message);
            }
            ctx.writeAndFlush((Object)message);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            boolean close = true;
            SocketUserSession userSession = (SocketUserSession)this.userSessions.getUserSession((Object)ctx);
            if (Objects.nonNull(this.idleHook)) {
                close = this.idleHook.callback((UserSession)userSession, (Object)event);
            }
            if (close) {
                this.userSessions.removeUserSession((UserSession)userSession);
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void setExternalCoreSetting(ExternalCoreSetting externalCoreSetting) {
        if (Objects.nonNull(this.userSessions)) {
            return;
        }
        DefaultExternalCoreSetting setting = (DefaultExternalCoreSetting)externalCoreSetting;
        IdleProcessSetting idleProcessSetting = setting.getIdleProcessSetting();
        this.idleHook = idleProcessSetting.getIdleHook();
        this.pong = idleProcessSetting.isPong();
        this.userSessions = setting.getUserSessions();
    }
}

