/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.handler;

import com.iohao.game.action.skeleton.core.exception.ActionErrorEnum;
import com.iohao.game.action.skeleton.core.exception.MsgExceptionInfo;
import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.external.core.aware.UserSessionsAware;
import com.iohao.game.external.core.config.ExternalGlobalConfig;
import com.iohao.game.external.core.hook.AccessAuthenticationHook;
import com.iohao.game.external.core.message.ExternalCodecKit;
import com.iohao.game.external.core.netty.session.SocketUserSession;
import com.iohao.game.external.core.netty.session.SocketUserSessions;
import com.iohao.game.external.core.session.UserSessions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;

@ChannelHandler.Sharable
public class SocketCmdAccessAuthHandler
extends SimpleChannelInboundHandler<BarMessage>
implements UserSessionsAware {
    protected UserSessions<?, ?> userSessions;

    protected void channelRead0(ChannelHandlerContext ctx, BarMessage message) {
        if (this.reject(ctx, message)) {
            return;
        }
        SocketUserSessions socketUserSessions = (SocketUserSessions)this.userSessions;
        SocketUserSession userSession = socketUserSessions.getUserSession(ctx);
        boolean loginSuccess = userSession.isVerifyIdentity();
        if (this.notPass(ctx, message, loginSuccess)) {
            return;
        }
        ctx.fireChannelRead((Object)message);
    }

    protected boolean reject(ChannelHandlerContext ctx, BarMessage message) {
        AccessAuthenticationHook accessAuthenticationHook = ExternalGlobalConfig.accessAuthenticationHook;
        int cmdMerge = message.getHeadMetadata().getCmdMerge();
        boolean reject = accessAuthenticationHook.reject(cmdMerge);
        if (reject) {
            ExternalCodecKit.employError((BarMessage)message, (MsgExceptionInfo)ActionErrorEnum.cmdInfoErrorCode);
            ctx.writeAndFlush((Object)message);
            return true;
        }
        return false;
    }

    protected boolean notPass(ChannelHandlerContext ctx, BarMessage message, boolean loginSuccess) {
        AccessAuthenticationHook accessAuthenticationHook = ExternalGlobalConfig.accessAuthenticationHook;
        int cmdMerge = message.getHeadMetadata().getCmdMerge();
        boolean pass = accessAuthenticationHook.pass(loginSuccess, cmdMerge);
        if (pass) {
            return false;
        }
        ExternalCodecKit.employError((BarMessage)message, (MsgExceptionInfo)ActionErrorEnum.verifyIdentity);
        ctx.writeAndFlush((Object)message);
        return true;
    }

    public void setUserSessions(UserSessions<?, ?> userSessions) {
        this.userSessions = userSessions;
    }
}

