/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty.handler;

import com.iohao.game.action.skeleton.protocol.BarMessage;
import com.iohao.game.external.core.config.ExternalGlobalConfig;
import com.iohao.game.external.core.hook.cache.ExternalCmdCache;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Objects;

@ChannelHandler.Sharable
public final class CmdCacheHandler
extends SimpleChannelInboundHandler<BarMessage> {
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ExternalCmdCache externalCmdCache = ExternalGlobalConfig.externalCmdCache;
        if (Objects.isNull(externalCmdCache)) {
            ctx.pipeline().remove((ChannelHandler)this);
        }
        super.channelActive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, BarMessage message) {
        ExternalCmdCache externalCmdCache = ExternalGlobalConfig.externalCmdCache;
        BarMessage cache = externalCmdCache.getCache(message);
        if (Objects.nonNull(cache)) {
            ctx.writeAndFlush((Object)cache);
            return;
        }
        ctx.fireChannelRead((Object)message);
    }

    public static CmdCacheHandler me() {
        return Holder.ME;
    }

    private static class Holder {
        static final CmdCacheHandler ME = new CmdCacheHandler();

        private Holder() {
        }
    }
}

