/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty;

import com.iohao.game.bolt.broker.core.client.BrokerAddress;
import com.iohao.game.external.core.ExternalServer;
import com.iohao.game.external.core.broker.client.ExternalBrokerClientStartup;
import com.iohao.game.external.core.config.ExternalJoinEnum;
import com.iohao.game.external.core.netty.DefaultExternalCore;
import com.iohao.game.external.core.netty.DefaultExternalCoreSetting;
import com.iohao.game.external.core.netty.DefaultExternalServer;
import java.util.Objects;

public final class DefaultExternalServerBuilder {
    private final DefaultExternalCoreSetting setting = new DefaultExternalCoreSetting();
    private ExternalBrokerClientStartup externalBrokerClientStartup = new ExternalBrokerClientStartup();
    private BrokerAddress brokerAddress;

    DefaultExternalServerBuilder(int externalCorePort) {
        this.setting.setExternalCorePort(externalCorePort);
    }

    public DefaultExternalServerBuilder externalJoinEnum(ExternalJoinEnum joinEnum) {
        this.setting.setExternalJoinEnum(joinEnum);
        return this;
    }

    public ExternalServer build() {
        this.check();
        DefaultExternalCore externalCore = new DefaultExternalCore(this.setting);
        return new DefaultExternalServer(this.setting, externalCore, this.brokerAddress, this.externalBrokerClientStartup);
    }

    private void check() {
        Objects.requireNonNull(this.externalBrokerClientStartup);
    }

    public DefaultExternalCoreSetting setting() {
        return this.setting;
    }

    public ExternalBrokerClientStartup externalBrokerClientStartup() {
        return this.externalBrokerClientStartup;
    }

    public BrokerAddress brokerAddress() {
        return this.brokerAddress;
    }

    public DefaultExternalServerBuilder externalBrokerClientStartup(ExternalBrokerClientStartup externalBrokerClientStartup) {
        this.externalBrokerClientStartup = externalBrokerClientStartup;
        return this;
    }

    public DefaultExternalServerBuilder brokerAddress(BrokerAddress brokerAddress) {
        this.brokerAddress = brokerAddress;
        return this;
    }
}

