/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty;

import com.iohao.game.bolt.broker.client.AbstractBrokerClientStartup;
import com.iohao.game.bolt.broker.client.BrokerClientApplication;
import com.iohao.game.bolt.broker.core.GroupWith;
import com.iohao.game.bolt.broker.core.aware.AwareInject;
import com.iohao.game.bolt.broker.core.client.BrokerAddress;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.client.BrokerClientBuilder;
import com.iohao.game.external.core.ExternalCore;
import com.iohao.game.external.core.ExternalServer;
import com.iohao.game.external.core.broker.client.ExternalBrokerClientStartup;
import com.iohao.game.external.core.micro.MicroBootstrap;
import com.iohao.game.external.core.micro.join.ExternalJoinSelector;
import com.iohao.game.external.core.micro.join.ExternalJoinSelectors;
import com.iohao.game.external.core.netty.DefaultExternalCoreSetting;
import com.iohao.game.external.core.netty.DefaultExternalServerBuilder;
import java.util.Objects;
import java.util.ServiceLoader;

public final class DefaultExternalServer
implements ExternalServer,
GroupWith {
    ExternalCore externalCore;
    DefaultExternalCoreSetting setting;
    ExternalBrokerClientStartup externalBrokerClientStartup;
    BrokerAddress brokerAddress;
    int withNo;

    DefaultExternalServer(DefaultExternalCoreSetting setting, ExternalCore externalCore, BrokerAddress brokerAddress, ExternalBrokerClientStartup externalBrokerClientStartup) {
        this.setting = setting;
        this.brokerAddress = brokerAddress;
        this.externalCore = externalCore;
        this.externalBrokerClientStartup = externalBrokerClientStartup;
    }

    public void startup() {
        MicroBootstrap microBootstrap = this.externalCore.createMicroBootstrap();
        String startExternalBrokerClient = System.getProperty("ExternalBrokerClientStartup", "true");
        if (Boolean.parseBoolean(startExternalBrokerClient)) {
            this.startExternalBrokerClient();
        }
        this.setting.inject();
        microBootstrap.startup();
    }

    private void startExternalBrokerClient() {
        this.externalBrokerClientStartup.setWithNo(this.withNo);
        BrokerClientBuilder brokerClientBuilder = BrokerClientApplication.initConfig((AbstractBrokerClientStartup)this.externalBrokerClientStartup);
        brokerClientBuilder.awareInject((AwareInject)this.setting);
        if (Objects.nonNull(this.brokerAddress)) {
            brokerClientBuilder.brokerAddress(this.brokerAddress);
        }
        BrokerClient brokerClient = BrokerClientApplication.start((BrokerClientBuilder)brokerClientBuilder);
        this.externalBrokerClientStartup.startupSuccess(brokerClient);
        this.setting.setBrokerClient(brokerClient);
    }

    public static DefaultExternalServerBuilder newBuilder(int externalCorePort) {
        return new DefaultExternalServerBuilder(externalCorePort);
    }

    public void setWithNo(int withNo) {
        this.withNo = withNo;
    }

    static {
        ServiceLoader.load(ExternalJoinSelector.class).forEach(ExternalJoinSelectors::putIfAbsent);
    }
}

