/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty;

import com.iohao.game.bolt.broker.core.aware.BrokerClientAware;
import com.iohao.game.bolt.broker.core.aware.CmdRegionsAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.common.kit.attr.AttrOptions;
import com.iohao.game.core.common.cmd.CmdRegions;
import com.iohao.game.core.common.cmd.DefaultCmdRegions;
import com.iohao.game.external.core.ExternalCoreSetting;
import com.iohao.game.external.core.aware.ExternalCoreSettingAware;
import com.iohao.game.external.core.aware.UserSessionsAware;
import com.iohao.game.external.core.config.ExternalJoinEnum;
import com.iohao.game.external.core.hook.UserHook;
import com.iohao.game.external.core.hook.internal.IdleProcessSetting;
import com.iohao.game.external.core.micro.MicroBootstrap;
import com.iohao.game.external.core.micro.MicroBootstrapFlow;
import com.iohao.game.external.core.session.UserSessions;
import java.util.Objects;
import java.util.Set;
import org.jctools.maps.NonBlockingHashSet;

public final class DefaultExternalCoreSetting
implements ExternalCoreSetting {
    private final AttrOptions options = new AttrOptions();
    private final CmdRegions cmdRegions = new DefaultCmdRegions();
    private final Set<Object> injectObject = new NonBlockingHashSet();
    private int externalCorePort;
    private ExternalJoinEnum externalJoinEnum = ExternalJoinEnum.WEBSOCKET;
    private MicroBootstrap microBootstrap;
    private MicroBootstrapFlow<?> microBootstrapFlow;
    private IdleProcessSetting idleProcessSetting;
    private UserSessions<?, ?> userSessions;
    private UserHook userHook;
    private BrokerClient brokerClient;

    public void inject() {
        this.injectObject.forEach(this::aware);
        if (Objects.nonNull(this.idleProcessSetting)) {
            this.aware(this.idleProcessSetting.getIdleHook());
        }
    }

    public void aware(Object o) {
        UserSessionsAware aware;
        if (o instanceof UserSessionsAware) {
            aware = (UserSessionsAware)o;
            aware.setUserSessions(this.userSessions);
        }
        if (o instanceof BrokerClientAware) {
            aware = (BrokerClientAware)o;
            aware.setBrokerClient(this.brokerClient);
        }
        if (o instanceof CmdRegionsAware) {
            aware = (CmdRegionsAware)o;
            aware.setCmdRegions(this.cmdRegions);
        }
        if (o instanceof ExternalCoreSettingAware) {
            aware = (ExternalCoreSettingAware)o;
            aware.setExternalCoreSetting((ExternalCoreSetting)this);
        }
    }

    public <T> MicroBootstrapFlow<T> getMicroBootstrapFlow() {
        return this.microBootstrapFlow;
    }

    public void setMicroBootstrap(MicroBootstrap microBootstrap) {
        this.microBootstrap = microBootstrap;
        this.injectObject.add(this.microBootstrap);
    }

    public void setMicroBootstrapFlow(MicroBootstrapFlow<?> microBootstrapFlow) {
        this.microBootstrapFlow = microBootstrapFlow;
        this.injectObject.add(this.microBootstrapFlow);
    }

    public void setIdleProcessSetting(IdleProcessSetting idleProcessSetting) {
        this.idleProcessSetting = idleProcessSetting;
        this.injectObject.add(this.idleProcessSetting);
    }

    public void setUserSessions(UserSessions<?, ?> userSessions) {
        this.userSessions = userSessions;
        this.injectObject.add(this.userSessions);
    }

    public void setUserHook(UserHook userHook) {
        this.userHook = userHook;
        this.injectObject.add(this.userHook);
    }

    public AttrOptions getOptions() {
        return this.options;
    }

    public CmdRegions getCmdRegions() {
        return this.cmdRegions;
    }

    public Set<Object> getInjectObject() {
        return this.injectObject;
    }

    public int getExternalCorePort() {
        return this.externalCorePort;
    }

    public ExternalJoinEnum getExternalJoinEnum() {
        return this.externalJoinEnum;
    }

    public MicroBootstrap getMicroBootstrap() {
        return this.microBootstrap;
    }

    public IdleProcessSetting getIdleProcessSetting() {
        return this.idleProcessSetting;
    }

    public UserSessions<?, ?> getUserSessions() {
        return this.userSessions;
    }

    public UserHook getUserHook() {
        return this.userHook;
    }

    public BrokerClient getBrokerClient() {
        return this.brokerClient;
    }

    public void setExternalCorePort(int externalCorePort) {
        this.externalCorePort = externalCorePort;
    }

    public void setExternalJoinEnum(ExternalJoinEnum externalJoinEnum) {
        this.externalJoinEnum = externalJoinEnum;
    }

    public void setBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }
}

