/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.external.core.netty;

import com.iohao.game.action.skeleton.core.DataCodecKit;
import com.iohao.game.action.skeleton.core.codec.ProtoDataCodec;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.common.kit.PresentKit;
import com.iohao.game.common.kit.ProtoKit;
import com.iohao.game.external.core.ExternalCore;
import com.iohao.game.external.core.ExternalCoreSetting;
import com.iohao.game.external.core.config.ExternalJoinEnum;
import com.iohao.game.external.core.hook.UserHook;
import com.iohao.game.external.core.hook.internal.DefaultUserHook;
import com.iohao.game.external.core.message.ExternalMessage;
import com.iohao.game.external.core.micro.MicroBootstrap;
import com.iohao.game.external.core.micro.join.ExternalJoinSelector;
import com.iohao.game.external.core.micro.join.ExternalJoinSelectors;
import com.iohao.game.external.core.netty.DefaultExternalCoreSetting;
import com.iohao.game.external.core.session.UserSessionOption;
import com.iohao.game.external.core.session.UserSessions;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExternalCore
implements ExternalCore {
    private static final Logger log = LoggerFactory.getLogger((String)"CommonStdout");
    final DefaultExternalCoreSetting setting;

    DefaultExternalCore(DefaultExternalCoreSetting setting) {
        this.setting = setting;
    }

    public MicroBootstrap createMicroBootstrap() {
        this.check();
        this.defaultSetting();
        int externalCorePort = this.setting.getExternalCorePort();
        if (IoGameGlobalConfig.openLog) {
            log.info("\u542f\u52a8\u6e38\u620f\u5bf9\u5916\u670d port: [{}] \u8fde\u63a5\u65b9\u5f0f: [{}] ", (Object)externalCorePort, (Object)this.setting.getExternalJoinEnum().getName());
        }
        this.aware();
        MicroBootstrap microBootstrap = this.setting.getMicroBootstrap();
        microBootstrap.setExternalCoreSetting((ExternalCoreSetting)this.setting);
        return microBootstrap;
    }

    private void check() {
        int externalCorePort = this.setting.getExternalCorePort();
        if (externalCorePort <= 0) {
            throw new IllegalArgumentException("\u6e38\u620f\u5bf9\u5916\u670d\u7aef\u53e3\u5fc5\u987b >0 " + externalCorePort);
        }
        Objects.requireNonNull(this.setting.getExternalJoinEnum(), "\u9700\u8981\u8bbe\u7f6e\u4e00\u79cd\u8fde\u63a5\u65b9\u5f0f:" + Arrays.toString(ExternalJoinEnum.values()));
    }

    private void defaultSetting() {
        ExternalJoinEnum joinEnum = this.setting.getExternalJoinEnum();
        ExternalJoinSelector externalJoinSelector = ExternalJoinSelectors.getExternalJoinSelector((ExternalJoinEnum)joinEnum);
        externalJoinSelector.defaultSetting((ExternalCoreSetting)this.setting);
        PresentKit.ifNull((Object)this.setting.getUserHook(), () -> this.setting.setUserHook((UserHook)new DefaultUserHook()));
        UserSessions<?, ?> userSessions = this.setting.getUserSessions();
        userSessions.setUserHook(this.setting.getUserHook());
        userSessions.option(UserSessionOption.externalJoin, (Object)joinEnum);
        if (DataCodecKit.getDataCodec() instanceof ProtoDataCodec) {
            ProtoKit.create(ExternalMessage.class);
        }
    }

    private void aware() {
        UserHook userHook = this.setting.getUserHook();
        UserSessions<?, ?> userSessions = this.setting.getUserSessions();
        userSessions.setUserHook(userHook);
    }
}

