/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit.micro.room;

import com.iohao.game.common.kit.micro.room.MicroRoom;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;

public class MicroRooms<Room extends MicroRoom> {
    private final Map<Long, Room> roomMap = new NonBlockingHashMap();
    private Supplier<Room> roomSupplier;

    public boolean contains(long id) {
        return this.roomMap.containsKey(id);
    }

    public Room remove(long id) {
        return (Room)((MicroRoom)this.roomMap.remove(id));
    }

    public Room getRoom(long id) {
        return (Room)((MicroRoom)this.roomMap.get(id));
    }

    public Room add(Room room) {
        long id = room.getId();
        MicroRoom anyRegion = (MicroRoom)this.roomMap.putIfAbsent(id, room);
        if (Objects.isNull(anyRegion)) {
            anyRegion = (MicroRoom)this.roomMap.get(id);
        }
        return (Room)anyRegion;
    }

    public Optional<Room> optionalRoom(long id) {
        return Optional.ofNullable((MicroRoom)this.roomMap.get(id));
    }

    public Room ofRoom(long id) {
        MicroRoom region = (MicroRoom)this.roomMap.get(id);
        if (Objects.isNull(region)) {
            region = (MicroRoom)this.roomSupplier.get();
            region.setId(id);
            region = this.add(region);
        }
        return (Room)region;
    }

    public Stream<Room> stream() {
        return this.roomMap.values().stream();
    }

    public Map<Long, Room> getRoomMap() {
        return this.roomMap;
    }

    public void setRoomSupplier(Supplier<Room> roomSupplier) {
        this.roomSupplier = roomSupplier;
    }
}

