/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit.log;

import com.iohao.game.common.kit.StrKit;
import com.iohao.game.common.log.LoggerSpaceManager;
import java.io.File;
import org.slf4j.Logger;

public final class IoGameLoggerFactory {
    public static final String GAME_LOG_SPACE_PROPERTY = "ioGame.log.space";
    static String GAME_LOG_SPACE;
    static String commonDefaultName;
    static String connectionDefaultName;
    static final String LOG_PATH = "logging.path";
    static final String LOG_LEVEL = "com.iohao.game.common.log.level";
    static final String LOG_ENCODE = "com.iohao.game.common.log.encode";
    static final String COMMON_ENCODE = "file.encoding";

    public static void printConsole() {
        connectionDefaultName = commonDefaultName = "CommonStdout";
    }

    public static Logger getLogger(Class<?> clazz) {
        if (clazz == null) {
            return IoGameLoggerFactory.getLogger("");
        }
        return IoGameLoggerFactory.getLogger(clazz.getCanonicalName());
    }

    public static Logger getLogger(String name) {
        if (name == null || name.isEmpty()) {
            return LoggerSpaceManager.getLoggerBySpace((String)"", (String)GAME_LOG_SPACE);
        }
        return LoggerSpaceManager.getLoggerBySpace((String)name, (String)GAME_LOG_SPACE);
    }

    public static Logger getLoggerConnection() {
        return IoGameLoggerFactory.getLogger(connectionDefaultName);
    }

    public static Logger getLoggerCommon() {
        return IoGameLoggerFactory.getLogger(commonDefaultName);
    }

    public static Logger getLoggerExternal() {
        return IoGameLoggerFactory.getLogger("CommonExternal");
    }

    public static Logger getLoggerCommonStdout() {
        return IoGameLoggerFactory.getLogger("CommonStdout");
    }

    public static Logger getLoggerCluster() {
        return IoGameLoggerFactory.getLogger("ClusterDefault");
    }

    public static Logger getLoggerMsg() {
        return IoGameLoggerFactory.getLogger("MsgTransfer");
    }

    private IoGameLoggerFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void setCommonDefaultName(String commonDefaultName) {
        IoGameLoggerFactory.commonDefaultName = commonDefaultName;
    }

    static {
        String commonEncode;
        String logLevel;
        String logPath;
        GAME_LOG_SPACE = "com.iohao.game.common";
        commonDefaultName = "CommonDefault";
        connectionDefaultName = "ConnectionDefault";
        String logSpace = System.getProperty(GAME_LOG_SPACE_PROPERTY);
        if (null != logSpace && !logSpace.isEmpty()) {
            GAME_LOG_SPACE = logSpace;
        }
        if (StrKit.isBlank(logPath = System.getProperty(LOG_PATH))) {
            String logPathDefault = System.getProperty("user.home") + File.separator + "logs";
            System.setProperty(LOG_PATH, logPathDefault);
        }
        if (StrKit.isBlank(logLevel = System.getProperty(LOG_LEVEL))) {
            String logLevelDefault = "INFO";
            System.setProperty(LOG_LEVEL, logLevelDefault);
        }
        if (StrKit.isNotBlank(commonEncode = System.getProperty(COMMON_ENCODE))) {
            System.setProperty(LOG_ENCODE, commonEncode);
        } else {
            String logEncode = System.getProperty(LOG_ENCODE);
            if (StrKit.isBlank(logEncode)) {
                System.setProperty(LOG_ENCODE, "UTF-8");
            }
        }
    }
}

