/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit.concurrent;

import java.util.concurrent.atomic.AtomicInteger;

public class ThreadCreator {
    private String threadNamePrefix;
    private int threadPriority = 5;
    private boolean daemon = false;
    private ThreadGroup threadGroup;
    private final AtomicInteger threadCount = new AtomicInteger();

    public ThreadCreator(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public void setThreadGroupName(String name) {
        this.threadGroup = new ThreadGroup(name);
    }

    public Thread createThread(Runnable runnable) {
        Thread thread = new Thread(this.getThreadGroup(), runnable, this.nextThreadName());
        thread.setPriority(this.threadPriority);
        thread.setDaemon(this.daemon);
        return thread;
    }

    protected String nextThreadName() {
        String format = "%s-%d";
        return String.format(format, this.threadNamePrefix, this.threadCount.incrementAndGet());
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public AtomicInteger getThreadCount() {
        return this.threadCount;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }
}

