/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit.asm;

import com.esotericsoftware.reflectasm.ConstructorAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.iohao.game.common.kit.asm.ClassRefInfo;
import com.iohao.game.common.kit.asm.FieldRefInfo;
import com.iohao.game.common.kit.asm.MethodRefInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class ClassRefInfoBuilder {
    private Class<?> clazz;
    private ConstructorAccess<?> constructorAccess;
    private MethodAccess methodAccess;

    ClassRefInfoBuilder() {
    }

    ClassRefInfo build() {
        ClassRefInfo classRefInfo = new ClassRefInfo();
        classRefInfo.constructorAccess = this.constructorAccess;
        classRefInfo.methodAccess = this.methodAccess;
        classRefInfo.clazz = this.clazz;
        classRefInfo.methodRefInfoMap = this.createMethodMap();
        classRefInfo.filedRefInfoMap = this.createFieldMap();
        return classRefInfo;
    }

    private Map<String, FieldRefInfo> createFieldMap() {
        List<Field> fieldList = this.listField();
        return fieldList.stream().collect(Collectors.toMap(Field::getName, field -> {
            field.setAccessible(true);
            String fieldName = field.getName();
            fieldName = InternalStr.firstCharToUpperCase(fieldName);
            String methodGetName = "get" + fieldName;
            String methodSetName = "set" + fieldName;
            FieldRefInfo filedRefInfo = new FieldRefInfo();
            filedRefInfo.fieldName = fieldName;
            filedRefInfo.methodGetIndex = this.methodAccess.getIndex(methodGetName);
            filedRefInfo.methodSetIndex = this.methodAccess.getIndex(methodSetName);
            filedRefInfo.methodGetName = methodGetName;
            filedRefInfo.methodSetName = methodSetName;
            filedRefInfo.returnType = field.getType();
            filedRefInfo.field = field;
            return filedRefInfo;
        }));
    }

    private Map<String, MethodRefInfo> createMethodMap() {
        List<Method> methodList = this.listMethod();
        return methodList.stream().collect(Collectors.toMap(Method::getName, method -> {
            String methodName = method.getName();
            int methodIndex = this.methodAccess.getIndex(methodName);
            MethodRefInfo methodRefInfo = new MethodRefInfo();
            methodRefInfo.methodAccess = this.methodAccess;
            methodRefInfo.method = method;
            methodRefInfo.methodIndex = methodIndex;
            methodRefInfo.methodName = methodName;
            return methodRefInfo;
        }));
    }

    private List<Field> listField() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> nextClass = this.clazz; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = nextClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                fieldList.add(field);
            }
        }
        return fieldList;
    }

    private List<Method> listMethod() {
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Class<?> nextClass = this.clazz; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = nextClass.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                methodList.add(method);
            }
        }
        return methodList;
    }

    public ClassRefInfoBuilder setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public ClassRefInfoBuilder setConstructorAccess(ConstructorAccess<?> constructorAccess) {
        this.constructorAccess = constructorAccess;
        return this;
    }

    public ClassRefInfoBuilder setMethodAccess(MethodAccess methodAccess) {
        this.methodAccess = methodAccess;
        return this;
    }

    private static final class InternalStr {
        private static final char A_LOWER = 'a';
        private static final char A_UPPER = 'A';
        private static final char Z_LOWER = 'z';
        private static final int x = 32;

        public static String firstCharToUpperCase(String str) {
            char firstChar = str.charAt(0);
            if (firstChar >= 'a' && firstChar <= 'z') {
                char[] arr = str.toCharArray();
                arr[0] = (char)(arr[0] - 32);
                return String.valueOf(arr);
            }
            return str;
        }

        private InternalStr() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

