/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit;

import com.iohao.game.common.kit.InternalKit;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public final class TimeKit {
    public static ZoneId defaultZoneId = ZoneId.systemDefault();
    public static DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static volatile long currentTimeMillis = System.currentTimeMillis();

    public static long currentTimeMillis() {
        return currentTimeMillis;
    }

    public static int toSecond(LocalDateTime localDateTime) {
        return (int)TimeKit.toInstant(localDateTime).getEpochSecond();
    }

    public static long toMilli(LocalDateTime localDateTime) {
        return TimeKit.toInstant(localDateTime).toEpochMilli();
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        return localDateTime.atZone(defaultZoneId).toInstant();
    }

    public static LocalDateTime toLocalDateTime(long milliseconds) {
        Instant instant = Instant.ofEpochMilli(milliseconds);
        ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
        return zonedDateTime.toLocalDateTime();
    }

    public static String formatter(LocalDateTime localDateTime) {
        return localDateTime.format(defaultFormatter);
    }

    public static String formatter(long milliseconds) {
        LocalDateTime localDateTime = TimeKit.toLocalDateTime(milliseconds);
        return localDateTime.format(defaultFormatter);
    }

    public static boolean expire(long milliseconds) {
        return milliseconds - currentTimeMillis <= 0L;
    }

    private TimeKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        InternalKit.newTimeoutSeconds(new TimerTask(){

            public void run(Timeout timeout) {
                currentTimeMillis = System.currentTimeMillis();
                InternalKit.newTimeoutSeconds(this);
            }
        });
    }
}

