/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit;

import java.io.Serializable;
import java.time.LocalTime;

public class TimeBetweenKit
implements Serializable {
    static final int oneDayMinute = 1440;

    public static boolean betweenNowTime(String startTime, String endTime, LocalTime nowTime) {
        int startTimeIndex = TimeBetweenKit.convertTimeIndex(startTime);
        int endTimeIndex = TimeBetweenKit.convertTimeIndex(endTime);
        return TimeBetweenKit.betweenNowTime(startTimeIndex, endTimeIndex, nowTime);
    }

    public static boolean betweenNowTime(int startTimeIndex, int endTimeIndex, LocalTime nowTime) {
        boolean success;
        if (startTimeIndex == endTimeIndex) {
            return false;
        }
        int nowTimeIndex = TimeBetweenKit.convertTimeIndex(nowTime);
        if (startTimeIndex > endTimeIndex) {
            if (nowTimeIndex >= startTimeIndex) {
                success = true;
            } else {
                int upNowTimeIndex = nowTimeIndex + 1440;
                int upEndIndex = endTimeIndex + 1440;
                success = upNowTimeIndex >= startTimeIndex && upNowTimeIndex <= upEndIndex;
            }
        } else {
            success = nowTimeIndex >= startTimeIndex && nowTimeIndex <= endTimeIndex;
        }
        return success;
    }

    public static boolean betweenNowTime(String startTime, String endTime) {
        return TimeBetweenKit.betweenNowTime(startTime, endTime, LocalTime.now());
    }

    private static int convertTimeIndex(LocalTime localTime) {
        int hour = localTime.getHour();
        int minute = localTime.getMinute();
        return TimeBetweenKit.convertTimeIndex(hour, minute);
    }

    public static int convertTimeIndex(String time) {
        String[] split = time.split(":");
        int hours = Integer.parseInt(split[0]);
        int minute = Integer.parseInt(split[1]);
        return TimeBetweenKit.convertTimeIndex(hours, minute);
    }

    private static int convertTimeIndex(int hours, int minute) {
        return hours * 60 + minute;
    }
}

