/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit;

import com.iohao.game.common.kit.hutool.AdapterHuUtils;
import java.util.Map;
import lombok.NonNull;

public final class StrKit {
    public static String format(@NonNull CharSequence template, @NonNull Map<?, ?> map) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return AdapterHuUtils.format((CharSequence)template, map);
    }

    public static String format(@NonNull CharSequence template, Object ... params) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return AdapterHuUtils.format((CharSequence)template, (Object[])params);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty() || str.isBlank();
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StrKit.isEmpty(str);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StrKit.isBlank(cs);
    }

    private StrKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

