/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.iohao.game.common.kit.EmptyConst;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.util.Objects;
import org.slf4j.Logger;

public final class ProtoKit {
    static final Logger log = IoGameLoggerFactory.getLoggerCommonStdout();

    public static byte[] toBytes(Object data) {
        if (Objects.isNull(data)) {
            return EmptyConst.emptyBytes;
        }
        Class<?> clazz = data.getClass();
        Codec codec = ProtobufProxy.create(clazz);
        try {
            return codec.encode(data);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return EmptyConst.emptyBytes;
        }
    }

    public static <T> T parseProtoByte(byte[] data, Class<T> clazz) {
        if (Objects.isNull(data)) {
            return null;
        }
        Codec codec = ProtobufProxy.create(clazz);
        try {
            return (T)codec.decode(data);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private ProtoKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

