/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NetworkKit {
    public static final List<String> IP_BLACK_LIST = Arrays.asList("10.0.2.15");
    public static String LOCAL_IP = NetworkKit.getLocalIP();
    public static final Pattern ADDRESS_FORMAT = Pattern.compile("(?<host>^.*):(?<port>\\d+$)");

    public static boolean hasPort(String hostAndPort, int port) {
        int thatPort = NetworkKit.getPort(hostAndPort);
        return thatPort == port;
    }

    public static String getHost(String hostAndPort) {
        if (hostAndPort == null || hostAndPort.isEmpty()) {
            throw new IllegalArgumentException("host-and-port string must be present");
        }
        Matcher matcher = ADDRESS_FORMAT.matcher(hostAndPort);
        if (!matcher.find()) {
            throw new IllegalArgumentException("can't parse host-and-port string from: " + hostAndPort);
        }
        String host = matcher.group(1);
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("can't parse host from: " + hostAndPort);
        }
        return host;
    }

    public static int getPort(String hostAndPort) {
        int port;
        if (hostAndPort == null || hostAndPort.isEmpty()) {
            throw new IllegalArgumentException("host-and-port string must be present");
        }
        Matcher matcher = ADDRESS_FORMAT.matcher(hostAndPort);
        if (!matcher.find()) {
            throw new IllegalArgumentException("can't parse host-and-port string from: " + hostAndPort);
        }
        try {
            port = Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("can't parse port from: " + hostAndPort, ex);
        }
        return port;
    }

    public static boolean isInternalIp(String ipOrHost) {
        try {
            byte[] address = InetAddress.getByName(ipOrHost).getAddress();
            return NetworkKit.isInternalIp(address);
        }
        catch (Exception e) {
            System.out.println("Failed to get ip:" + e.getMessage());
            return false;
        }
    }

    public static boolean isInternalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        byte b2 = addr[2];
        byte b3 = addr[3];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        int SECTION_7 = 127;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                if (b1 == -88) {
                    return true;
                }
            }
            case 127: {
                if (b1 != 0 || b2 != 0 || b3 != 1) break;
                return true;
            }
        }
        return false;
    }

    private static String getLocalIP() {
        String ip = null;
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            block2: while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress inetAddress = ee.nextElement();
                    String hostAddress = inetAddress.getHostAddress();
                    if (!hostAddress.contains(".") || IP_BLACK_LIST.contains(hostAddress) || inetAddress.isLoopbackAddress()) continue;
                    ip = hostAddress;
                    continue block2;
                }
            }
            if (ip == null) {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (Exception ignore) {
            return "127.0.0.1";
        }
        return ip;
    }

    private NetworkKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

