/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;

public final class ExecutorKit {
    public static ExecutorService newSingleThreadExecutor(String namePrefix) {
        ThreadFactory threadFactory = ExecutorKit.createThreadFactory(namePrefix);
        return ExecutorKit.newSingleThreadExecutor(threadFactory);
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    public static ExecutorService newCacheThreadPool(String namePrefix) {
        ThreadFactory threadFactory = ExecutorKit.createThreadFactory(namePrefix);
        return ExecutorKit.newCacheThreadPool(threadFactory);
    }

    public static ExecutorService newCacheThreadPool(ThreadFactory threadFactory) {
        return Executors.newCachedThreadPool(threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return Executors.newFixedThreadPool(corePoolSize, threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int corePoolSize, String namePrefix) {
        ThreadFactory threadFactory = ExecutorKit.createThreadFactory(namePrefix);
        return ExecutorKit.newFixedThreadPool(corePoolSize, threadFactory);
    }

    public static ScheduledExecutorService newSingleScheduled(ThreadFactory threadFactory) {
        return ExecutorKit.newScheduled(1, threadFactory);
    }

    public static ScheduledExecutorService newSingleScheduled(String namePrefix) {
        ThreadFactory threadFactory = ExecutorKit.createThreadFactory(namePrefix);
        return ExecutorKit.newScheduled(1, threadFactory);
    }

    public static ScheduledExecutorService newScheduled(int corePoolSize, String namePrefix) {
        ThreadFactory threadFactory = ExecutorKit.createThreadFactory(namePrefix);
        return ExecutorKit.newScheduled(corePoolSize, threadFactory);
    }

    public static ScheduledExecutorService newScheduled(int corePoolSize, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    public static ThreadFactory createThreadFactory(String namePrefix) {
        return ExecutorKit.createThreadFactory(namePrefix, true);
    }

    public static ThreadFactory createThreadFactory(@NonNull String namePrefix, boolean daemon) {
        if (namePrefix == null) {
            throw new NullPointerException("namePrefix is marked non-null but is null");
        }
        AtomicLong threadNumber = new AtomicLong();
        return runnable -> {
            String threadName = namePrefix + threadNumber.getAndIncrement();
            Thread thread = new Thread(runnable, threadName);
            thread.setDaemon(daemon);
            return thread;
        };
    }

    private ExecutorKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

