/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit;

import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jctools.maps.NonBlockingHashSet;
import org.slf4j.Logger;

public class ClassScanner {
    static final Logger log = IoGameLoggerFactory.getLoggerCommonStdout();
    final String packagePath;
    final Set<Class<?>> clazzSet = new NonBlockingHashSet();
    final Predicate<Class<?>> predicateFilter;
    ClassLoader classLoader;

    public ClassScanner(String packagePath, Predicate<Class<?>> predicateFilter) {
        this.predicateFilter = predicateFilter;
        Object path = packagePath.replace('.', '/');
        this.packagePath = path = ((String)path).endsWith("/") ? path : (String)path + "/";
    }

    public List<Class<?>> listScan() {
        try {
            this.initClassLoad();
            List<URL> urlList = this.listResource();
            urlList.parallelStream().forEach(url -> {
                String protocol = url.getProtocol();
                try {
                    if ("jar".equals(protocol)) {
                        this.scanJar((URL)url);
                    } else if ("file".equals(protocol)) {
                        this.scanFile((URL)url);
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ArrayList(this.clazzSet);
    }

    private void initClassLoad() {
        if (Objects.nonNull(this.classLoader)) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.classLoader = classLoader != null ? classLoader : ClassScanner.class.getClassLoader();
    }

    public List<URL> listResource() throws IOException {
        this.initClassLoad();
        Enumeration<URL> urlEnumeration = this.classLoader.getResources(this.packagePath);
        HashSet<URL> urlSet = new HashSet<URL>();
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            urlSet.add(url);
        }
        return new ArrayList<URL>(urlSet);
    }

    private void scanJar(URL url) throws IOException {
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof JarURLConnection) {
            JarURLConnection jarUrlConn = (JarURLConnection)urlConn;
            try (JarFile jarFile = jarUrlConn.getJarFile();){
                Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
                while (jarEntryEnumeration.hasMoreElements()) {
                    JarEntry jarEntry = jarEntryEnumeration.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(".class") || !jarEntryName.startsWith(this.packagePath)) continue;
                    jarEntryName = jarEntryName.substring(0, jarEntryName.length() - 6).replace('/', '.');
                    this.scanClazz(jarEntryName);
                }
            }
        }
    }

    private void scanFile(URL url) {
        String path = url.getPath();
        path = URLDecoder.decode(path, StandardCharsets.UTF_8);
        File file = new File(path);
        String classPath = this.getClassPath(file);
        this.scanFile(file, classPath);
    }

    private void scanFile(File file, String classPath) {
        String absolutePath;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (Objects.isNull(files)) {
                return;
            }
            for (File value : files) {
                this.scanFile(value, classPath);
            }
        } else if (file.isFile() && (absolutePath = file.getAbsolutePath()).endsWith(".class")) {
            String className = absolutePath.substring(classPath.length(), absolutePath.length() - 6).replace(File.separatorChar, '.');
            this.scanClazz(className);
        }
    }

    private String getClassPath(File file) {
        String ret;
        int index;
        Object absolutePath = file.getAbsolutePath();
        if (!((String)absolutePath).endsWith(File.separator)) {
            absolutePath = (String)absolutePath + File.separator;
        }
        if ((index = ((String)absolutePath).lastIndexOf(ret = this.packagePath.replace('/', File.separatorChar))) != -1) {
            absolutePath = ((String)absolutePath).substring(0, index);
        }
        return absolutePath;
    }

    private void scanClazz(String className) {
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        if (clazz != null && !this.clazzSet.contains(clazz) && this.predicateFilter.test(clazz)) {
            this.clazzSet.add(clazz);
        }
    }
}

