/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.kit;

import com.iohao.game.common.kit.RandomKit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class ArrayKit {
    public static int sum(int[] cards) {
        return Arrays.stream(cards).sum();
    }

    public static int[] copy(int[] cards) {
        int length = cards.length;
        int[] copyCards = new int[length];
        System.arraycopy(cards, 0, copyCards, 0, length);
        return copyCards;
    }

    public static List<Integer> toList(int[] cards) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < cards.length; ++i) {
            int num = cards[i];
            if (num == 0) continue;
            for (int j = 0; j < num; ++j) {
                list.add(i);
            }
        }
        return list;
    }

    public static void subtract(int[] cards, int[] beCards) {
        for (int i = 0; i < cards.length; ++i) {
            cards[i] = cards[i] - beCards[i];
        }
    }

    public static void plus(int[] cards, int[] beCards) {
        for (int i = 0; i < cards.length; ++i) {
            cards[i] = cards[i] + beCards[i];
        }
    }

    public static void plus(int[] cards, List<Integer> beCards) {
        for (Integer value : beCards) {
            int n = value;
            cards[n] = cards[n] + 1;
        }
    }

    public static List<Integer> random(int[] cards, int size) {
        List<Integer> list = ArrayKit.toList(cards);
        list = list.subList(0, size);
        return list;
    }

    public static String join(Object[] array, CharSequence delimiter) {
        return Arrays.stream(array).map(Object::toString).collect(Collectors.joining(delimiter));
    }

    public static boolean notEmpty(Object[] array) {
        return array != null && array.length != 0;
    }

    public static boolean notEmpty(byte[] array) {
        return !ArrayKit.isEmpty(array);
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T random(T[] array) {
        int i = RandomKit.randomInt(array.length);
        return array[i];
    }

    private ArrayKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

