/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.common.internal;

import com.iohao.game.common.internal.BootItemConfig;
import com.iohao.game.common.kit.ClassScanner;
import com.iohao.game.common.kit.log.IoGameLoggerFactory;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;

public class BootItemConfigKit {
    static final Logger log = IoGameLoggerFactory.getLoggerCommonStdout();

    public static void loadBootItemConfig(Class<? extends BootItemConfig> packClazz) {
        Predicate<Class<?>> predicate = BootItemConfig.class::isAssignableFrom;
        String packagePath = packClazz.getPackageName();
        ClassScanner classScanner = new ClassScanner(packagePath, predicate);
        List<Class<?>> classList = classScanner.listScan();
        for (Class<?> clazz : classList) {
            try {
                BootItemConfig itemConfig = (BootItemConfig)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                itemConfig.config();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

