/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor.connection;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.iohao.game.bolt.broker.core.aware.BrokerClientItemAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.client.BrokerClientItem;
import com.iohao.game.bolt.broker.core.client.BrokerClientManager;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegionKit;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseConnectEventClientProcessor
implements ConnectionEventProcessor,
BrokerClientItemAware {
    private static final Logger log = LoggerFactory.getLogger((String)"ConnectionTopic");
    private final AtomicBoolean dicConnected = new AtomicBoolean();
    private final AtomicInteger disConnectTimes = new AtomicInteger();
    BrokerClientItem brokerClientItem;

    public void onEvent(String remoteAddress, Connection conn) {
        long connectIndex = 2L;
        ExecutorRegionKit.getSimpleThreadExecutor((long)connectIndex).executeTry(() -> this.extracted(remoteAddress, conn));
    }

    private void extracted(String remoteAddress, Connection conn) {
        if (IoGameGlobalConfig.openLog) {
            log.info("\u7f51\u5173\u65ad\u5f00 ConnectionEventType:\u3010{}\u3011 remoteAddress:\u3010{}\u3011\uff0cConnection:\u3010{}\u3011", new Object[]{ConnectionEventType.CLOSE, remoteAddress, conn});
        }
        Objects.requireNonNull(conn);
        this.dicConnected.set(true);
        this.disConnectTimes.incrementAndGet();
        BrokerClient brokerClient = this.brokerClientItem.getBrokerClient();
        BrokerClientManager brokerClientManager = brokerClient.getBrokerClientManager();
        brokerClientManager.remove(this.brokerClientItem);
        if (IoGameGlobalConfig.openLog) {
            log.info("\u7f51\u5173\u65ad\u5f00 ConnectionEventType:\u3010{}\u3011 remoteAddress:\u3010{}\u3011\uff0c\u7f51\u5173\u8fde\u63a5\u6570\u91cf:\u3010{}\u3011", new Object[]{ConnectionEventType.CLOSE, remoteAddress, brokerClientManager.countActiveItem()});
        }
    }

    public boolean isDisConnected() {
        return this.dicConnected.get();
    }

    public int getDisConnectTimes() {
        return this.disConnectTimes.get();
    }

    public void reset() {
        this.disConnectTimes.set(0);
        this.dicConnected.set(false);
    }

    public void setBrokerClientItem(BrokerClientItem brokerClientItem) {
        this.brokerClientItem = brokerClientItem;
    }
}

