/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.iohao.game.action.skeleton.core.BarSkeleton;
import com.iohao.game.action.skeleton.core.flow.FlowContext;
import com.iohao.game.action.skeleton.core.flow.FlowContextKit;
import com.iohao.game.action.skeleton.core.flow.attr.FlowAttr;
import com.iohao.game.action.skeleton.protocol.RequestMessage;
import com.iohao.game.bolt.broker.client.action.skeleton.BoltChannelContext;
import com.iohao.game.bolt.broker.core.aware.BrokerClientAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.common.AbstractAsyncUserProcessor;
import com.iohao.game.bolt.broker.core.common.processor.hook.ClientProcessorHooks;
import com.iohao.game.bolt.broker.core.common.processor.hook.RequestMessageClientProcessorHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMessageClientProcessor
extends AbstractAsyncUserProcessor<RequestMessage>
implements BrokerClientAware {
    private static final Logger log = LoggerFactory.getLogger((String)"CommonStdout");
    BrokerClient brokerClient;
    RequestMessageClientProcessorHook requestMessageClientProcessorHook;

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, RequestMessage request) {
        try {
            BrokerClient brokerClient = this.brokerClient;
            BarSkeleton barSkeleton = brokerClient.getBarSkeleton();
            FlowContext flowContext = barSkeleton.getFlowContextFactory().createFlowContext();
            flowContext.setRequest(request);
            flowContext.setBarSkeleton(barSkeleton);
            BoltChannelContext channelContext = new BoltChannelContext(asyncCtx);
            flowContext.option(FlowAttr.channelContext, (Object)channelContext);
            flowContext.option(FlowAttr.brokerClientContext, (Object)brokerClient);
            flowContext.option(FlowAttr.logicServerId, (Object)brokerClient.getId());
            flowContext.option(FlowAttr.logicServerTag, (Object)brokerClient.getTag());
            flowContext.option(FlowAttr.aggregationContext, (Object)brokerClient.getCommunicationAggregationContext());
            FlowContextKit.employ((FlowContext)flowContext);
            this.requestMessageClientProcessorHook.processLogic(barSkeleton, flowContext);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    public void setBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
        ClientProcessorHooks clientProcessorHooks = brokerClient.getClientProcessorHooks();
        this.requestMessageClientProcessorHook = clientProcessorHooks.getRequestMessageClientProcessorHook();
    }

    public String interest() {
        return RequestMessage.class.getName();
    }
}

