/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.BizContext;
import com.alipay.remoting.rpc.protocol.AsyncUserProcessor;
import com.iohao.game.action.skeleton.toy.IoGameBanner;
import com.iohao.game.bolt.broker.core.aware.BrokerClientItemAware;
import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.client.BrokerClientItem;
import com.iohao.game.bolt.broker.core.client.BrokerClientManager;
import com.iohao.game.bolt.broker.core.common.IoGameGlobalConfig;
import com.iohao.game.bolt.broker.core.message.RequestBrokerClientModuleMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBrokerClientModuleMessageClientProcessor
extends AsyncUserProcessor<RequestBrokerClientModuleMessage>
implements BrokerClientItemAware {
    private static final Logger log = LoggerFactory.getLogger(RequestBrokerClientModuleMessageClientProcessor.class);
    BrokerClientItem brokerClientItem;

    public void handleRequest(BizContext bizCtx, AsyncContext asyncCtx, RequestBrokerClientModuleMessage request) {
        if (IoGameGlobalConfig.requestResponseLog) {
            log.info("bizCtx.getRemoteAddress() : {}", (Object)bizCtx.getRemoteAddress());
        }
        int withNo = request.getWithNo();
        this.brokerClientItem.setBrokerServerWithNo(withNo);
        this.brokerClientItem.registerToBroker();
        if (IoGameGlobalConfig.requestResponseLog) {
            BrokerClient brokerClient = this.brokerClientItem.getBrokerClient();
            BrokerClientManager brokerClientManager = brokerClient.getBrokerClientManager();
            log.info("brokerClientItems : {}", (Object)brokerClientManager.countActiveItem());
        }
        IoGameBanner.me().countDown();
    }

    public String interest() {
        return RequestBrokerClientModuleMessage.class.getName();
    }

    public void setBrokerClientItem(BrokerClientItem brokerClientItem) {
        this.brokerClientItem = brokerClientItem;
    }
}

