/*
 * Decompiled with CFR 0.152.
 */
package com.iohao.game.bolt.broker.client.processor;

import com.iohao.game.bolt.broker.core.client.BrokerClient;
import com.iohao.game.bolt.broker.core.client.BrokerClientAttr;
import com.iohao.game.bolt.broker.core.common.processor.listener.BrokerClientListenerRegion;
import com.iohao.game.bolt.broker.core.message.BrokerClientModuleMessage;
import com.iohao.game.common.kit.concurrent.executor.ExecutorRegionKit;
import java.util.Set;

public final class BrokerClientLineKit {
    public static void executeSafe(BrokerClientModuleMessage moduleMessage, Runnable runnable) {
        String tag = moduleMessage.getTag();
        int index = Math.abs(tag.hashCode());
        ExecutorRegionKit.getSimpleThreadExecutor((long)index).executeTry(runnable);
    }

    public static void onlineProcess(BrokerClientModuleMessage moduleMessage, BrokerClient brokerClient) {
        String moduleMessageId = moduleMessage.getId();
        Set onlineListenerRecordSet = (Set)brokerClient.option(BrokerClientAttr.onlineListenerRecordSet);
        if (onlineListenerRecordSet.contains(moduleMessageId)) {
            return;
        }
        onlineListenerRecordSet.add(moduleMessageId);
        Set offlineListenerRecordSet = (Set)brokerClient.option(BrokerClientAttr.offlineListenerRecordSet);
        offlineListenerRecordSet.remove(moduleMessageId);
        BrokerClientListenerRegion listenerRegion = brokerClient.getBrokerClientListenerRegion();
        listenerRegion.forEach(listener -> {
            switch (moduleMessage.getBrokerClientType()) {
                case EXTERNAL: {
                    listener.onlineExternal(moduleMessage, brokerClient);
                    break;
                }
                case LOGIC: {
                    listener.onlineLogic(moduleMessage, brokerClient);
                }
            }
        });
    }

    public static void offlineProcess(BrokerClientModuleMessage moduleMessage, BrokerClient brokerClient) {
        String moduleMessageId = moduleMessage.getId();
        Set offlineListenerRecordSet = (Set)brokerClient.option(BrokerClientAttr.offlineListenerRecordSet);
        if (offlineListenerRecordSet.contains(moduleMessageId)) {
            return;
        }
        offlineListenerRecordSet.add(moduleMessageId);
        Set onlineListenerRecordSet = (Set)brokerClient.option(BrokerClientAttr.onlineListenerRecordSet);
        onlineListenerRecordSet.remove(moduleMessageId);
        BrokerClientListenerRegion listenerRegion = brokerClient.getBrokerClientListenerRegion();
        listenerRegion.forEach(listener -> {
            switch (moduleMessage.getBrokerClientType()) {
                case EXTERNAL: {
                    listener.offlineExternal(moduleMessage, brokerClient);
                    break;
                }
                case LOGIC: {
                    listener.offlineLogic(moduleMessage, brokerClient);
                }
            }
        });
    }

    private BrokerClientLineKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

